<?php
include_once("../../../../param.php");
?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Expenses Budget</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-6 col-lg-8">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image-padding" style="display:inline;width: 40px !important;" src="//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/media/iconExpenses.png" >
                    Budget
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-6 col-lg-2">


            </div>
            <div class="col-xs-12 col-sm-4 col-md-6 col-lg-2">

                <span class="pull-right show-stat-buttons"> <span > <a target="_blank" href="//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/views/new_expenses_category_budget.php" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New Budget Category</a> </span>

            </div>
        </div>



        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Budget Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:3%"></th>                                        <th class="hasinput" style="width:10%"><input type="text" class="form-control text-center" placeholder="year" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="month" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="Company Code" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="Company" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="Category" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="Category Arabic" /></th>
                                        <th class="hasinput" style="width:15%"><input type="text" class="form-control  text-center" placeholder="Budget" /></th>
                                        <th class="hasinput" style="width:3%"></th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'></th>
                                        <th class='text-center'>Month</th>
                                        <th class='text-center'>Year</th>
                                        <th class='text-center'>Company Code</th>
                                        <th class='text-center'>Company</th>
                                        <th class='text-center'>Category</th>
                                        <th class='text-center'>Category Arabic</th>
                                        <th class='text-center'>Budget</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>
                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>

</div>


</div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function deleteBudget(year,month,companyID,accountID){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/controllers/deleteBudgetRecord.php',
            data: {
                'year': year,
                'month': month,
                'companyID': companyID,
                'accountID': accountID
            },
            success: function (result) {
                $.smallBox({
                    title: "Success!",
                    content: "Delete Budget",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                $('#datatable_fixed_column').DataTable().ajax.reload( null, false );
            }
        });
    }

    $(document).ready(function() {

        pageSetUp();

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,
            "processing": false,
            "serverSide": true,
            "ajax": "//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/controllers/getExpensesCategoryBudget.php",
            "columns": [
                { "data": "logo" },
                { "data": "month" },
                { "data": "year" },
                { "data": "companyCode" },
                { "data": "company" },
                { "data": "category" },
                { "data": "categoryArabic" },
                { "data": "budget" },
                { "data": "actions" }
            ],
            "deferRender": true,
            "order": [[ 1, "asc" ],[ 2, "asc" ]],
            "buttons": ['copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ],
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
        });
        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();
        } );
        /* END COLUMN FILTER */

    })


</script>