<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$groupContractHeaderID =  trim($_POST['groupContractHeaderID']);
$customerID         = trim($_POST['customerID']);
$contractDate       = trim($_POST['contractDate']);
$serviceCallID      = trim($_POST['serviceCallID']);
$currencyID         = trim($_POST['currencyID']);
$subtotal           = trim($_POST['subtotal']);
$discount           = trim($_POST['discount']);
$vatTotal           = trim($_POST['vatTotal']);
$grandTotal         = trim($_POST['grandTotal']);
$details            = trim($_POST['details']);
$salespersonSearch  = trim($_POST['salespersonSearch']);
$revisionCode       = trim($_POST['revisionCode']);
$validFrom          = trim($_POST['validFrom']);
$validUntil            = trim($_POST['validUntil']);

$status             = "Placed";

$orderItems         = array();
$orderItems         = json_decode($_POST['contractLines'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$db2 = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");


try {
    $db->begin_transaction();

    $contractID   = getNextKeySingleTransaction("Group_Contracts_Documents", "group_contract_doc_id", $db);
    $groupContractCode = getNextCodeSingleTransaction("Group_Contracts_Documents", "group_contract_doc_code", "C", "CLOUD", $db);

    if (strcmp($groupContractCode, '') == 0) {
        $groupContractCode = getNextTenderCode("CLOUD", $db);
    }

    if(strcmp(trim($revisionCode),'')!=0){
        $revisionDelimiter = '/';
        $originalContractCode = explode($revisionDelimiter,$revisionCode)[0];
        $stm = $db->prepare("SELECT count(group_contract_doc_id) FROM Group_Contracts_Documents WHERE group_contract_doc_code LIKE '$originalContractCode$revisionDelimiter%' ");
        $stm->execute();
        $stm->bind_result($revisionCounter);
        while ($stm->fetch()) {$revisionCounter++;}
        $stm->close();
        $groupContractCode = $originalContractCode.$revisionDelimiter.$revisionCounter;
    }

    if (isset($contractDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $contractDate);
        $contractDate = $date->format('Y-m-d');
    }

    if (isset($validFrom) && strcmp("$validFrom", "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $validFrom);
        $validFrom = $date->format('Y-m-d');
    }

    if (isset($validUntil) && strcmp("$validUntil", "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $validUntil);
        $validUntil = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }


    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Group_Contracts_Documents (group_contract_doc_id,group_contract_doc_code,customer_id,salesperson_id,subtotal,grand_total,vat_amount,discount_amount,contract_date,details,global_discount_percentage,status,currency_id,group_contract_header_id,valid_from,valid_until) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiddddssdsiiss', $contractID, $groupContractCode, $customerID, $salespersonSearch, $subtotal, $grandTotal, $vatTotal, $discount, $contractDate, $details, $globalDiscountPercentage, $status, $currencyID,$groupContractHeaderID,$validFrom,$validUntil);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
    $stmt->close();


    $lineTotals = 0;
    $lineDiscountTotals = 0;


    if (count($orderItems) == 0) {throw new Exception();}

    $relatedDocIDs = findRelatedDocumentIDs(0,$groupContractHeaderID,$db2);
    $relatedExistingItems = array();
    foreach ($relatedDocIDs as $relatedDocID) {
        $existingItems = findExistingItemIDs($relatedDocID, $db2);
        $relatedExistingItems[$relatedDocID] = $existingItems;
    }


    foreach ($orderItems as $orderItem) {
        $itemID = $orderItem['itemID'];
        if ($itemID != 0) {

            $qty             = $orderItem['Qty'];
            $unitPrice       = $orderItem['UP'];
            $lineDiscount    = $orderItem['LD'];
            $priceType       = $orderItem['PC'];
            $globalDiscount  = $orderItem['globalDiscount'];
            $vatTotal        = $orderItem['vatLine'];
            $vatCode         = $orderItem['VAT'];
            $itemDescription = $orderItem['Notes'];

            if ($qty == 0) {continue;}

            $subunits = getSubUnits($itemID, $db);
            $vatID    = getVatID($vatCode, $db);


            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }


            $lineTotals += floatval($unitPrice * $qty / $subunits);
            $lineDiscountTotals += floatval($lineDiscount);

            $contractLineID = getNextKeySingleTransaction("Group_Contracts_Documents_Lines", "group_contract_doc_line_id", $db);

            $stmt = $db->prepare("INSERT INTO Group_Contracts_Documents_Lines (group_contract_doc_line_id,group_contract_doc_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $contractLineID, $contractID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemDescription);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
            $stmt->close();

            // insert into related docs if needed
            foreach ( $relatedDocIDs as $relatedDocID) {
                if(!in_array($itemID,    $relatedExistingItems[$relatedDocID])) {
                    $contractLineID = getNextKeySingleTransaction("Group_Contracts_Documents_Lines", "group_contract_doc_line_id", $db);
                    $stmt = $db->prepare("INSERT INTO Group_Contracts_Documents_Lines (group_contract_doc_line_id,group_contract_doc_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param('iiidddddiids', $contractLineID, $relatedDocID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemDescription);
                    $stmt->execute();
                    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                    $stmt->close();

                }
            }


        }

    }

    $discount = floatval($discount);
    $discount += floatval($lineDiscountTotals);

    $stmt = $db->prepare("UPDATE  Group_Contracts_Documents SET subtotal =? ,discount_amount=? WHERE group_contract_doc_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $contractID);
    $stmt->execute();
    $stmt->close();

//    if ($serviceCallID > 0) {
//        date_default_timezone_set('Europe/Athens');
//        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
//        $status = 0;
//        $timezone = 2;
//        $date = date("Y-m-d H:i:s");
//        $replyTypeID = 3;
//        $details = "New Group Contract Issued";
//        $documentType = "Group_Contracts_Documents";
//        $salespersonTo = 0;
//        $emailResponse = "";
//        $priorityID = 0;
//        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
//        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonSearch, $status, $date, $replyTypeID, $details, $contractID, $documentType, $salespersonTo, $emailResponse, $priorityID);
//        $stmt->execute();
//        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
//        $stmt->close();
//    }


    // delete the items from other docs
    $existingCurrentDocItems = array();
    foreach ($orderItems as $orderItem) {
        $existingCurrentDocItems[] = $orderItem['itemID'];
    }
  ;
    foreach ($relatedDocIDs as $relatedDocID) {
        $relatedExistingItems = findExistingItemIDs($relatedDocID,$db2);

        foreach ($relatedExistingItems as $relatedItem) {
            if (!in_array($relatedItem, $existingCurrentDocItems)) {
                $stmt = $db->prepare("DELETE FROM Group_Contracts_Documents_Lines WHERE group_contract_doc_id = ? AND item_id = ? ");
                $stmt->bind_param('ii', $relatedDocID, $relatedItem);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();

            }
        }
    }


    //update amounts for the related Documents
    foreach ($relatedDocIDs as $relatedDocID) {
        $lineTotals = 0;
        $lineDiscountTotals=0;
        $vatAmountTotals=0;

        $stmt = $db->prepare("SELECT  item_id, qty,unit_price,line_discount, global_discount,vat_amount FROM Group_Contracts_Documents_Lines WHERE group_contract_doc_id=?");

        $stmt->bind_param('i', $relatedDocID);
        $stmt->execute();

        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->bind_result($itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount);
        while($stmt->fetch()){

            $subunits = getSubUnits($itemID, $db2);
            $qty = floatval($qty);
            $unitPrice = floatval($unitPrice);
            $lineDiscount = floatval($lineDiscount);
            $globalDiscount = floatval($globalDiscount);
            $vatAmount = floatval($vatAmount);


            $lineTotals += $unitPrice * $qty / $subunits;
            $lineDiscountTotals += $lineDiscount + $globalDiscount;
            $vatAmountTotals += $vatAmount;
        }
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();

        $grandTotal = $vatAmountTotals + $lineTotals - $lineDiscountTotals;



        $stmt = $db->prepare("UPDATE  Group_Contracts_Documents SET subtotal =?, grand_total = ?,discount_amount=?,vat_amount =? WHERE group_contract_doc_id=?");
        $stmt->bind_param('ddddi', $lineTotals, $grandTotal, $lineDiscountTotals, $vatAmountTotals,$relatedDocID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();

    }

    $db->commit(true);

    if ($serviceCallID > 0) {
        echo "$contractID&service_call_id=$serviceCallID";
    } else {
        echo "$contractID";
    }

} catch (Exception  $e) {
    echo 'error';
    //echo $e->getMessage();
    $db->rollback();
}




function findExistingItemIDs($groupContractDocID,$db2) {
    $existingCurrentDocItems =array();
    $stmt = $db2->prepare("SELECT item_id FROM Group_Contracts_Documents_Lines WHERE group_contract_doc_id = ?");
    $stmt->bind_param('i', $groupContractDocID);
    $stmt->execute();
    $stmt->bind_result($existingItemID);

    while ($stmt->fetch()) {
        $existingCurrentDocItems[] = $existingItemID;
    }
    $stmt->close();
    return $existingCurrentDocItems;
}

function findRelatedDocumentIDs($groupContractDocID, $groupContractHeaderID,$db2) {
    $relatedDocIDs = array();
    $stmt = $db2->prepare("SELECT group_contract_doc_id FROM Group_Contracts_Documents WHERE group_contract_header_id = ? AND group_contract_doc_id != ?");
    $stmt->bind_param('ii', $groupContractHeaderID, $groupContractDocID);
    $stmt->execute();
    $stmt->bind_result($relatedDocID);
    while ($stmt->fetch()) {
        $relatedDocIDs[] = $relatedDocID;
    }
    $stmt->close();

    return $relatedDocIDs;
}



function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;
}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}

?>