<?php
include_once("../../../../param.php");

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

$dateFrom = trim($_POST['dateFrom']);
$dateTo = trim($_POST['dateTo']);


if(strcmp($dateFrom,'')==0){$dateFrom = date('Y-m-d');}
if(strcmp($dateTo,'')==0){$dateTo = date('Y-m-d');}


$workingDays = 1;
$res = getKPIsBySalesperson($dateFrom,$dateTo);
$res1 = calculateKPIobject($res,$workingDays);
echo json_encode($res1);
//viewArray($res1);
function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}

function calculateKPIobject($kpiObj,$workingDays){
    $res1 = array();
    $areaTotalPlanned = 0;
    $areaTotalPlannedVisited = 0;
    $areaTotalUnplannedVisited = 0;
    $areaTotalTotalVisited = 0;
    $areaTotalNotVisited = 0;
    $areaTotalStrikeVisited = 0;
    $areaTotalStrikeNotvisited = 0;
    foreach ($kpiObj as $kpi){

        $totalVisited = (int)$kpi->planned_visited + (int)$kpi->unplanned_visited;
        $notVisited = (int)$kpi->planned - (int)$kpi->planned_visited;
        $strikeNotVisited = (int)$kpi->strike_all - (int)$kpi->strike_visited;

        $plannedPercent = round(($totalVisited / (int)$kpi->planned)*100);
        $plannedVisitedPercent = round(((int)$kpi->planned_visited / (int)$kpi->planned)*100);
        $unPlannedVisitedPercent = round(((int)$kpi->unplanned_visited / (int)$kpi->planned)*100);

        $strikeVisitedPercent = round(((int)$kpi->strike_visited / (int)$totalVisited)*100);
        $strikePercent = round((((int)$kpi->strike_visited + $strikeNotVisited) / ($totalVisited + $strikeNotVisited))*100);
        $notInvoicedPercent = round((($totalVisited - (int)$kpi->strike_visited)/$totalVisited)*100);
        $failedToVisitPercent = round(($notVisited / $kpi->planned)*100);

        $calculateObject = new stdClass();
        $salespersonInfo = getSalespersonInfo($kpi->salesperson_id);
        $calculateObject->salesperson_code = $salespersonInfo->code;
        $calculateObject->salesperson_name = $salespersonInfo->name;
        $calculateObject->planned = (int)$kpi->planned;
        $calculateObject->planned_visited = (int)$kpi->planned_visited;
        $calculateObject->unplanned_visited = (int)$kpi->unplanned_visited;
        $calculateObject->total_visited = (int)$totalVisited;
        $calculateObject->not_visited = (int)$notVisited;
        $calculateObject->strike_visited = (int)$kpi->strike_visited;
        $calculateObject->strike_not_visited = (int)$strikeNotVisited;
        $calculateObject->planned_visited_percent = (int)$plannedVisitedPercent;
        $calculateObject->strike_visited_percent = (int)$strikeVisitedPercent;
        $calculateObject->daily_strike_percent = (int)$strikePercent;
        $calculateObject->unplanned_visited_percent = (int)$unPlannedVisitedPercent;
        $calculateObject->total_visited_percent = (int)$plannedPercent;

        $calculateObject->budget_1 = round((int)$kpi->budget_1 / $workingDays);
        $calculateObject->budget_2 = round((int)$kpi->budget_2 / $workingDays);
        $calculateObject->total_qty_1 = (int)$kpi->total_qty_1;
        $calculateObject->total_qty_2 = (int)$kpi->total_qty_2;
        $calculateObject->qty_1_percent = round(((int)$kpi->total_qty_1 / ((int)$kpi->budget_1 / $workingDays))*100);
        $calculateObject->qty_2_percent = round(((int)$kpi->total_qty_2 / ((int)$kpi->budget_2 / $workingDays))*100);

//        SUM ALL
        $areaTotalPlanned += $kpi->planned;
        $areaTotalPlannedVisited += $kpi->planned_visited;
        $areaTotalUnplannedVisited += $kpi->unplanned_visited;
        $areaTotalTotalVisited += $totalVisited;
        $areaTotalNotVisited += $notVisited;
        $areaTotalStrikeVisited += $kpi->strike_visited;
        $areaTotalStrikeNotvisited += $strikeNotVisited;
//        SUM ALL

        $res1[$kpi->salesperson_id] = $calculateObject;
    }
    if ($areaTotalPlanned>0){
        $areaTotalPlannedPercent = round(($areaTotalTotalVisited / (int)$areaTotalPlanned)*100);
        $areaTotalPlannedVisitedPercent = round(((int)$areaTotalPlannedVisited / (int)$areaTotalPlanned)*100);
        $areaTotalUnPlannedVisitedPercent = round(((int)$areaTotalUnplannedVisited / (int)$areaTotalPlanned)*100);
        $areaTotalStrikeVisitedPercent = round(((int)$areaTotalStrikeVisited / (int)$areaTotalTotalVisited)*100);
        $areaTotalStrikeStrikePercent = round((((int)$areaTotalStrikeVisited + $areaTotalStrikeNotvisited) / ($areaTotalTotalVisited + $areaTotalStrikeNotvisited))*100);
    }else{
        $areaTotalPlannedPercent = 0;
        $areaTotalPlannedVisitedPercent = 0;
        $areaTotalUnPlannedVisitedPercent = 0;
        $areaTotalStrikeVisitedPercent = 0;
        $areaTotalStrikeStrikePercent = 0;
    }


    $calculateObjectAll = new stdClass();
    $calculateObjectAll->salespersonCode = 'ALL';
    $calculateObjectAll->planned_visited_percent = $areaTotalPlannedVisitedPercent;
    $calculateObjectAll->strike_visited_percent = $areaTotalStrikeVisitedPercent;
    $calculateObjectAll->daily_strike_percent = $areaTotalStrikeStrikePercent;
    $calculateObjectAll->unplanned_visited_percent = $areaTotalUnPlannedVisitedPercent;
    $calculateObjectAll->total_visited_percent = $areaTotalPlannedPercent;

    $res1['all'] = $calculateObjectAll;
    return $res1;
}

function getKPIsBySalesperson($dateFrom,$dateTo){
    global $username,$password,$database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $salespersonArray = array();
    $stm2 = $db2->prepare("SELECT salesperson_id , salesperson_code, date, SUM(planned), SUM(planned_visited), SUM(unplanned_visited), SUM(strike_visited), SUM(strike_all), SUM(total_qty), SUM(number_of_sales_documents), SUM(number_of_receipts), SUM(total_receipts), SUM(total_qty_1), SUM(total_qty_2), SUM(total_qty_3), SUM(total_qty_4), SUM(total_qty_5), SUM(budget_1), SUM(budget_1), SUM(budget_3), SUM(budget_4), SUM(budget_5), balance FROM Z_Z_KPIS_VISITS WHERE date >= '$dateFrom' AND date <= '$dateTo' GROUP BY salesperson_id");
    $stm2-> execute();
    $stm2-> bind_result($salesperson_id, $salesperson_code, $date, $planned, $planned_visited, $unplanned_visited, $strike_visited, $strike_all, $total_qty, $number_of_sales_documents, $number_of_receipts, $total_receipts, $total_qty_1, $total_qty_2, $total_qty_3, $total_qty_4, $total_qty_5, $budget_1, $budget_2, $budget_3, $budget_4, $budget_5, $balance);
    while ($stm2->fetch()) {
        $kpiObject = new stdClass();
        $kpiObject->salesperson_id = $salesperson_id;
        $kpiObject->salesperson_code = $salesperson_code;
        $kpiObject->date = $date;
        $kpiObject->planned = $planned;
        $kpiObject->planned_visited = $planned_visited;
        $kpiObject->unplanned_visited = $unplanned_visited;
        $kpiObject->strike_visited = $strike_visited;
        $kpiObject->strike_all = $strike_all;
        $kpiObject->total_qty = $total_qty;
        $kpiObject->number_of_sales_documents = $number_of_sales_documents;
        $kpiObject->number_of_receipts = $number_of_receipts;
        $kpiObject->total_receipts = $total_receipts;
        $kpiObject->total_qty_1 = $total_qty_1;
        $kpiObject->total_qty_2 = $total_qty_2;
        $kpiObject->budget_1 = $budget_1;
        $kpiObject->budget_2 = $budget_2;
        $kpiObject->balance = $balance;

        $salespersonArray[$salesperson_id] = $kpiObject;
    }
    $stm2-> close();
    return $salespersonArray;
}

function getSalespersonInfo($salespersonID){
    global $username,$password,$database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $resObj = new stdClass();
    $stm2 = $db2->prepare("SELECT salesperson_code,CONCAT(first_name, ' ', last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID' ");
    $stm2-> execute();
    $stm2-> bind_result( $salespersonCode,$salespersonName);
    while ($stm2->fetch()) {
        $resObj->code = $salespersonCode;
        $resObj->name = $salespersonName;
    }
    $stm2-> close();
    return $resObj;
}

?>