<?php
error_reporting(100);
include_once("../../../../param.php");
require_once(ROOT . 'libs/mPDF/vendor/autoload.php');


function generateProductCatalogue()
{
    $catalogueLogo  = trim($_POST['catalogueLogo']);
    if(strcmp($catalogueLogo,"custom")==0){
        if(file_exists(ROOT . 'backend/modules/productCatalogue/media/customLogo.png')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/customLogo.png";
        } else if(file_exists(ROOT . 'backend/modules/productCatalogue/media/customLogo.jpg')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/customLogo.jpg";
        } else if(file_exists(ROOT . 'backend/modules/productCatalogue/media/customLogo.jpeg')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/customLogo.jpeg";
        } else {
            $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
        }
    } else if(strcmp($catalogueLogo,"catalogueDefaultLogo")==0){
        if(file_exists(ROOT . 'backend/modules/productCatalogue/media/defaultlogo.png')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.png";
        } else if(file_exists(ROOT . "backend/modules/productCatalogue/media/defaultlogo.jpg")){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.jpg";
        } else if(file_exists(ROOT . 'backend/modules/productCatalogue/media/defaultlogo.jpeg')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.jpeg";
        } else {
            $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
        }
    } else if(strcmp($catalogueLogo,"noLogo")==0) {
        $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/white_no.png";
    } else if(strcmp($catalogueLogo,"companyLogo")==0) {
        $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
    } else {
        if(file_exists(ROOT . 'backend/modules/productCatalogue/media/defaultlogo.png')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.png";
        } else if(file_exists(ROOT . "backend/modules/productCatalogue/media/defaultlogo.jpg")){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.jpg";
        } else if(file_exists(ROOT . 'backend/modules/productCatalogue/media/defaultlogo.jpeg')){
            $logoDirectory = "//" . HTML_PATH . "/cop/backend/modules/productCatalogue/media/defaultlogo.jpeg";
        } else {
            $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
        }
    }
    $logoDirectory.= "?".time();

    if(file_exists('./customBackground.png')){
        $backgroundDirectory = "background-image: url(\"//" . HTML_PATH . "/cop/backend/modules/productCatalogue/controllers/customBackground.png\");";
    } else if(file_exists('./customBackground.jpg')){
        $backgroundDirectory = "background-image: url(\"//" . HTML_PATH . "/cop/backend/modules/productCatalogue/controllers/customBackground.jpg\");";
    } else if(file_exists('./customBackground.jpeg')){
        $backgroundDirectory = "background-image: url(\"//" . HTML_PATH . "/cop/backend/modules/productCatalogue/controllers/customBackground.jpeg\");";
    } else {
        $backgroundDirectory = "";
    }

    $imageSizePx          = trim($_POST['imageSizePx']);
    $fontSizePx           = trim($_POST['fontSizePx']);
    $itemsPerRow          = trim($_POST['itemsPerRow']);
    $alignProducts        = trim($_POST['alignProducts']);
    $fromCategories       = $_POST['fromCategories'];
    $borderColor          = trim($_POST['borderColor']);
    $showTitles           = trim($_POST['showTitles']);
    $showBorders          = trim($_POST['showBorders']);
    $showImage            = trim($_POST['showImage']);
    $showName             = trim($_POST['showName']);
    $showSku              = trim($_POST['showSku']);
    $showCode             = trim($_POST['showCode']);
    $showBarcode          = trim($_POST['showBarcode']);
    $showNumericBarcode   = trim($_POST['showNumericBarcode']);
    $showStatus           = trim($_POST['showStatus']);
    $showUnits            = trim($_POST['showUnits']);
    $showPacking          = trim($_POST['showPacking']);
    $showSubunits         = trim($_POST['showSubunits']);
    $showVatCode          = trim($_POST['showVatCode']);
    $showVatPercent       = trim($_POST['showVatPercent']);
    $showPrice            = trim($_POST['showPrice']);
    $showSubCategories    = trim($_POST['showSubCategories']);
    $newPagePerCategory   = trim($_POST['newPagePerCategory']);
    $showInactive         = trim($_POST['showInactive']);
    $priceTypeID          = trim($_POST['priceTypeID']);
    $showBothPrices       = trim($_POST['showBothPrices']);
    $showCategoryTitles   = trim($_POST['showCategoryTitles']);
    $showLongDescription  = trim($_POST['showLongDescription']);
    $showShortDescription = trim($_POST['showShortDescription']);
    $showMultiCategoryItems = trim($_POST['showMultiCategoryItems']);
    $pageTitle            = trim($_POST['pageTitle']);
    $pageRightSideAddress = trim($_POST['pageRightSideAddress']);
    $sortItemsBy          = trim($_POST['sortItemsBy']);
    $sortingAscDesc       = trim($_POST['sortingAscDesc']);
    $landScape            = trim($_POST['landScape']);
    $groupByCategoryLevel = trim($_POST['groupByCategoryLevel']);
    $includeHeader = trim($_POST['includeHeader']);


    if(strcmp($fromCategories,'')==0){
        $fromCategories = 1;
    }

    if(strcmp($showTitles,'true')==0){$showTitles = true;}
    if(strcmp($showBorders,'true')==0){$showBorders = true;}
    if(strcmp($showImage,'true')==0){$showImage = true;}
    if(strcmp($showName,'true')==0){$showName = true;}
    if(strcmp($showSku,'true')==0){$showSku = true;}
    if(strcmp($showCode,'true')==0){$showCode = true;}
    if(strcmp($showNumericBarcode,'true')==0){$showNumericBarcode = true;}
    if(strcmp($showBarcode,'true')==0){$showBarcode = true;}
    if(strcmp($showStatus,'true')==0){$showStatus = true;}
    if(strcmp($showUnits,'true')==0){$showUnits = true;}
    if(strcmp($showPacking,'true')==0){$showPacking = true;}
    if(strcmp($showSubunits,'true')==0){$showSubunits = true;}
    if(strcmp($showVatCode,'true')==0){$showVatCode = true;}
    if(strcmp($showVatPercent,'true')==0){$showVatPercent = true;}
    if(strcmp($showPrice,'true')==0){$showPrice = true;}
    if(strcmp($showSubCategories,'true')==0){$showSubCategories = true;}
    if(strcmp($newPagePerCategory,'true')==0){$newPagePerCategory = true;}
    if(strcmp($showInactive,'true')==0){$showInactive = true;}
    if(strcmp($showBothPrices,'true')==0){$showBothPrices = true;}
    if(strcmp($showCategoryTitles,'true')==0){$showCategoryTitles = true;}
    if(strcmp($showLongDescription,'true')==0){$showLongDescription = true;}
    if(strcmp($showShortDescription,'true')==0){$showShortDescription = true;}
    if(strcmp($showMultiCategoryItems,'true')==0){$showMultiCategoryItems = true;}
    if(strcmp($landScape,'true')==0){$landScape = true;}
    if(strcmp($groupByCategoryLevel,'true')==0){$groupByCategoryLevel = true;}
    if(strcmp($includeHeader,'true')==0){$includeHeader = true;}

    if(!$showBorders){
        $borderColor = "transparent";
    }

    if(!$showCategoryTitles){
        $displayCategory = "display: none;";
    }

    if(!$showInactive){
        $notInactive = "AND NOT status = 'inactive'";
    }
    if($newPagePerCategory){
        $pagebreak = "class='pageBreak'";
    }

    $imageWidth = $imageHeight = $imageSizePx;
    $imageWidthTd = $imageHeightTd= $imageSizePx/3;

    $fontSizeListLabelsPx = $fontSizePx+2;

    $fontSizeListLabelsPx .= "px";
    $imageWidthTd .= "px";
    $imageWidth  .= "px";
    $imageHeight .= "px";
    $fontSizePx  .= "px";


    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    if(strcmp($fromCategories,'')!=0) {

        $arrayItemsCategory = array();
        $othersCategories = array();
        $extraFilterCategoryItems = "";
        if ($groupByCategoryLevel){
            $stm = $db->prepare("SELECT item_id FROM Category_Item WHERE category_id IN($fromCategories)");
            $stm->execute();
            $stm->bind_result($itemID);
            while ($stm->fetch()) {
                array_push($arrayItemsCategory,$itemID);
            }
            $stm->close();

            if (count($arrayItemsCategory)>0){
                $arrayItemsCategoryImplode = implode(',',$arrayItemsCategory);
                $extraFilterCategoryItems = " AND Category_Item.item_id IN($arrayItemsCategoryImplode)";
                $stm = $db->prepare("SELECT Categories.category_id FROM Categories,Category_Item WHERE Categories.category_id=Category_Item.category_id AND Categories.level=1 AND item_id IN($arrayItemsCategoryImplode) GROUP BY Categories.category_id");
                $stm->execute();
                $stm->bind_result($categoryIDother);
                while ($stm->fetch()) {
                    array_push($othersCategories,$categoryIDother);
                }
                $stm->close();
            }

            if (count($othersCategories)>0){
                $fromCategories = implode(',',$othersCategories);
            }
        }

        $stm = $db->prepare("SELECT category_code, name, category_id FROM Categories WHERE category_id IN($fromCategories)");
        $stm->execute();
        $stm->bind_result($categoryCode, $categoryName, $categoryID);
        while ($stm->fetch()) {
            if($showSubCategories) {
                $fromCategories .= getSubCategories($categoryID);
            }
        }
        $stm->close();


        if(strcmp($sortingAscDesc,'DESC')!=0){$sortingAscDesc = 'ASC';}

        if(strcmp($sortItemsBy,'')==0 || strcmp($sortItemsBy,'position')==0){
            $sortItemsByFilter=",Category_Item.position ASC, Items.name $sortingAscDesc";
        } else {
            $sortItemsByFilter= ",Items.$sortItemsBy $sortingAscDesc, Category_Item.position ASC";
        }

        $categoryItemTable = ",Category_Item,Categories";
        $categoryNameColumn = ",Categories.name";
        $categoryItemJoin = "AND Category_Item.item_id=Items.item_id AND Category_Item.category_id=Categories.category_id";
        $itemsFromCategories = "AND Category_Item.category_id IN($fromCategories) $extraFilterCategoryItems ORDER BY Categories.level ASC, Categories.custom_order ASC, Categories.name ASC $sortItemsByFilter";
    }


    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {}
    $stm->close();


    $counter = 0;
    $items = array();
    $result = array();
    $multiCategoryItems = array();
    $categoriesNames = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT Items.item_id,sales_units,thumbnail_url,subunits,Items.vat_id,Items.item_code,Items.name,price,vat_code,percentage,packing,item_sku,Items.short_description,Items.long_description,Items.status$categoryNameColumn FROM Items, Prices, PriceTypes, Vats $categoryItemTable WHERE Vats.vat_id=Items.vat_id $categoryItemJoin AND Prices.item_id=Items.item_id AND Prices.pricetype_id=PriceTypes.pricetype_id AND default_type = 'yes' $notInactive $itemsFromCategories");
    $stm->execute();
    $stm->bind_result($itemID, $uom, $image, $subunits, $vatID, $itemCode, $name, $unitPrice,$vatCode,$vatPercentage,$packing,$sku,$shortDescription,$longDescription,$status,$categoryName);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID'");
        $stm2->execute();
        $stm2->bind_result($barcode);
        while ($stm2->fetch()) {}
        $stm2->close();

        if(strcmp($uom,'multiple')==0){
            $prevMultiplier = 1;
            $prevUom = '';
            $uomBlock = '';
            $uomTrail = '';
            $stm2 = $db2->prepare("SELECT description,multiplier FROM UOM_Item,UOMs WHERE UOM_Item.uom_id=UOMs.uom_id AND active='yes' AND item_id='$itemID' ORDER BY multiplier ASC");
            $stm2->execute();
            $stm2->bind_result($multiUom,$multiplier);
            while ($stm2->fetch()) {
                if(strcmp($prevUom,'')!=0){
                    if($prevMultiplier <= $multiplier){
                        $uomBlock .= "$multiUom ($multiplier $prevUom)<br>";
                    }
                } else {
                    $uomTrail = "Price per $multiUom<br>";
                    $prevUom = $multiUom;
                }



            }
            $stm2->close();

            $uom = $uomBlock.$uomTrail;
        }

        if(strcmp($priceTypeID,'')!=0) {
            $stm2 = $db2->prepare("SELECT price, name FROM Prices,PriceTypes WHERE Prices.pricetype_id=PriceTypes.pricetype_id AND item_id='$itemID' AND Prices.pricetype_id='$priceTypeID'");
            $stm2->execute();
            $stm2->bind_result($selectedUnitPrice, $priceTypeName);
            while ($stm2->fetch()) {
                if(!$showBothPrices) {
                    $unitPrice = $selectedUnitPrice;
                }
            }
            $stm2->close();
        }


        if(strcmp($status, 'inactive')!=0 && strcmp($status, 'Inactive')!=0){
            $DisplayStatus = "Active";
        } else {
            $DisplayStatus = "Inactive";
        }
        if(strcmp($itemCode,'')!=0) {
            $counter++;

            if(strcmp("$categoryName","")==0){$categoryName = " ";}

            $item = new stdClass();
            $item->counter = $counter;
            $item->code = $itemCode;
            $item->sku = $sku;
            $item->name = $name;
            $item->shortDescription = $shortDescription;
            $item->longDescription = $longDescription;
            $item->uom = $uom;
            $item->subunits = $subunits;
            $item->packing = $packing;
            $item->barcode = $barcode;
            $item->unitPrice = number_format($unitPrice,2);
            $item->unitPrice2 = number_format($selectedUnitPrice,2);
            $item->vatCode = $vatCode;
            $item->vatPercentage = $vatPercentage;
            $item->image = $image;
            $item->status = $DisplayStatus;
            $item->category = $categoryName;
            $item->priceTypeName = $priceTypeName;

            $multiCategoryItems[$itemCode][$categoryName]=$counter;

            array_push($items, $item);
            array_push($categoriesNames, $categoryName);
        }
    }
    $stm->close();

    if(strcmp($pageRightSideAddress,'')!=0){
        $displayRightSiteCompanyInfo = "<h2 class='heading' style='text-align: right;'><pre style='background-color: transparent;border-color: transparent;margin: 0px;padding: 0px;'>$pageRightSideAddress</pre></h2>";
    } else {
        $displayRightSiteCompanyInfo = "<h2 class='heading' style='text-align: right;'>
                                            $line2<br/>
                                            $line3<br/>
                                            $line4<br/>
                                            $line5<br/>
                                            $line6<br/>
                                            $line7
                                        </h2>";
    }

    $multiCategoryItemTotals = array_map("count", $multiCategoryItems);
    $noOfCategories = count(explode(',',$fromCategories));

    if(strcmp($itemsPerRow,"list")==0){$tableStyleForList='border-collapse:collapse;width:100%;';$imageHeight = "auto";}else{$tableStyleForList='';}

    $resultHeader = "
    <meta charset='UTF-8'>
<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           $backgroundDirectory

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        


       .pagebreak
        {


            page-break-after:always;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }
        

        

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

      

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>";

    if($includeHeader) {

        $resultHeader .= " <htmlpageheader name='myHTMLHeader1'>
                              <table class='heading' style='width: 100%'>
                              <tr>
                              <td valign='top' style='width:30%'>
                                  <img style='display:block;max-width: 200px;' src='$logoDirectory'/>
                              </td>
                              <td  valign='top' style='width:40%' align='center'>
                                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>$pageTitle </p><p style='display:block;font-weight:bold; font-size:14px; width:100%'><br/><br/></p>
                              </td>
                              <td valign='top' style='width:30%' align='right'>
                                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;text-align: right;'>$line1</h1>
                                            $displayRightSiteCompanyInfo
                              </td>
                               </tr>
                              </table>      
                            </htmlpageheader>           
                              ";
    }
    $resultHeader.="  <table style='$tableStyleForList border:1px solid $borderColor;'>
                                    <tr>";
    $counter = 0;
    $rowCounter = 1;
    $pageCounter = 0;
    $categoryCheck = "";
    if(strcmp($itemsPerRow,"list")==0){


        foreach ($items as $item) {

            if (strcmp($categoryCheck, "") == 0) {
                $categoryDisplayName = $item->category;
                if($showMultiCategoryItems){$categoryDisplayName = implode(' - ',array_unique($categoriesNames));}
                $result[$pageCounter] .= "</tr></table><h2>
                                     <b>
                                        <div style='margin-top: 40px;margin-bottom: 10px;$displayCategory' align='center'>$categoryDisplayName</div>
                                     </b>
                                  </h2>
                                  <div align='$alignProducts'>
                                    <table style='$tableStyleForList border:1px solid $borderColor;'>
                                        <tr>";
                $categoryCheck = $item->category;
            } else if (strcmp($categoryCheck, $item->category) != 0) {

                $result[$pageCounter] .= "</tr></table>
                                          <div $pagebreak ></div>
                                          <h2>
                                            <b>
                                                <div style='margin-top: 60px;margin-bottom: 10px;$displayCategory' align='center'>$item->category</div>
                                            </b>
                                          </h2>
                                          <table style='$tableStyleForList border:1px solid $borderColor;'>
                                              <tr>";
                $counter = 1;
                $rowCounter = 1;
                $categoryCheck = $item->category;
            }

            if($rowCounter == 1){


                if($showImage){
                    $result[$pageCounter].="<td style='width:20%;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Image</td>";
                }
                if($showName){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Name</td>";
                }
                if($showSku){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Sku</td>";
                }
                if($showCode){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Code</td>";
                }
                if($showNumericBarcode){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Numeric Bar Code</td>";
                }
                if($showBarcode){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Barcode</td>";
                }
                if($showStatus){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Status</td>";
                }
                if($showUnits){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Units</td>";
                }
                if($showPacking){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Packing</td>";
                }
                if($showSubunits){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Subnits</td>";
                }
                if($showVatCode){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Vat</td>";
                }
                if($showVatPercent){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Vat Percent</td>";
                }
                if($showPrice){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Price</td>";
                }
                if ($showBothPrices && strcmp($priceTypeID, '') != 0) {
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>$priceTypeName</td>";
                }

                if($showShortDescription){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Short Description</td>";
                }
                if($showLongDescription){
                    $result[$pageCounter].="<td style='width:auto;border:1px solid $borderColor;font-size:$fontSizeListLabelsPx;text-align: center;background:#F0F8FF;'>Long Description</td>";
                }
                $result[$pageCounter].="</tr>";
            }


            if($rowCounter >=15){
                $rowCounter = 1;
                $pageCounter++;

            }



            $result[$pageCounter].="<tr>";
            if ($showImage) {
                if (strcmp($item->image, '') != 0) {
                    $imageURL = '//' . HTML_PATH . '/cop/media/productImages/' . $item->image . '.jpg';
                    $imageFile = ROOT . 'media/productImages/' . $item->image . '.jpg';
                    if (!file_exists($imageFile)) {
                        $imageURL = $logoDirectory;
                    }
                } else {
                    $imageURL = $logoDirectory;
                }
                $result[$pageCounter].=     "<td  style='width: $imageWidthTd; height: $imageHeightTd; border: 0.2px solid $borderColor;text-align: center;'> ";
                if(strcmp("$imageFile",'')==0){
                    $imageFile = $logoDirectory;
                }

                $img_size_array = getimagesize($imageFile);
                $width = $img_size_array[0];
                $height = $img_size_array[1];
                if($height>$width){
                    $result[$pageCounter].="<img src='$imageURL' style='height: auto;width:$imageWidthTd'>";
                }else{
                    $result[$pageCounter].=" <img src='$imageURL' style='width: $imageWidth; height: $imageHeight;'>";
                }
                $result[$pageCounter].="  </td>";
            }

            if ($showName) {
                $result[$pageCounter].= "                    
                                                               
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->name</td>";

            }

            if ($showSku) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->sku</td>";
            }

            if ($showCode) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->code</td>";
            }

            if ($showNumericBarcode) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->barcode</td>";
            }


             if ($showBarcode)  {
                   $result[$pageCounter].= "<td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>";
                   if(strcmp($item->barcode, '') != 0){
                     $result[$pageCounter].= "<center><div align='center' style='border: 1px solid black;background-image: linear-gradient(90deg, #ffffff 25%, #000000 25%, #000000 50%, #ffffff 50%, #ffffff 75%, #000000 75%, #000000 100%);background-size: 4.00px 4.00px;'><barcode code='$item->barcode' text='$item->barcode' type='C128B' class='barcode' style='border: 1px solid transparent;width: 100%' />";
                   }
                   $result[$pageCounter].= "</td>";
              }

            if ($showStatus) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->status</td>";
            }

            if ($showUnits) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->uom</td>";
            }

            if ($showPacking) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->packing</td>";
            }

            if ($showSubunits) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->subunits</td>";
            }

            if ($showVatCode) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->vatCode</td>";
            }

            if ($showVatPercent) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->vatPercentage%</td>";
            }

            if ($showPrice) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->unitPrice</td>";
            }
            if ($showBothPrices && strcmp($priceTypeID, '') != 0) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->unitPrice2</td>";
            }

            if ($showShortDescription) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->shortDescription</td>";
            }

            if ($showLongDescription) {
                $result[$pageCounter].= "                   
                                                <td  style='width:auto;font-size:$fontSizePx;border: 0.2px solid $borderColor;'>$item->longDescription</td>";
            }


            $result[$pageCounter].="</tr>";

            $rowCounter++;

        }

    } else {
        foreach ($items as $item) {
        $showItem = true;
        if($showMultiCategoryItems){
            $categoriesCount = $multiCategoryItemTotals[$item->code];
            if($categoriesCount < $noOfCategories) {
                $showItem = false;
            } else {
                $multiCategoryItemTotals[$item->code] = 0;
//                $item->category = $categoriesNames = implode(' - ',array_unique($categoriesNames));
            }
        }
        if($showItem) {
            if (strcmp($item->image, '') != 0) {
                $imageURL = '//' . HTML_PATH . '/cop/media/productImages/' . $item->image . '.jpg';
                $imageFile = ROOT . 'media/productImages/' . $item->image . '.jpg';
                if (!file_exists($imageFile)) {
                    $imageURL = $logoDirectory;
                }
            } else {
                $imageURL = $logoDirectory;
            }

            $counter++;
            if (!$showTitles) {
                $display = "display:none;";
            }


            if (strcmp($categoryCheck, "") == 0) {
                $categoryDisplayName = $item->category;
                if($showMultiCategoryItems){$categoryDisplayName = implode(' - ',array_unique($categoriesNames));}
                $result[$pageCounter] .= "</tr></table><h2>
                                     <b>
                                        <div style='margin-top: 40px;margin-bottom: 10px;$displayCategory' align='center'>$categoryDisplayName</div>
                                     </b>
                                  </h2>
                                  <div align='$alignProducts'>
                                    <table>
                                        <tr>";
                $categoryCheck = $item->category;
            } else if (strcmp($categoryCheck, $item->category) != 0) {

                $result[$pageCounter] .= "</tr></table>
                                          <div $pagebreak ></div>
                                          <h2>
                                            <b>
                                                <div style='margin-top: 60px;margin-bottom: 10px;$displayCategory' align='center'>$item->category</div>
                                            </b>
                                          </h2>
                                          <table>
                                              <tr>";
                $counter = 1;
                $rowCounter++;
                $categoryCheck = $item->category;
            }

            if ($counter > $itemsPerRow) {
                $result[$pageCounter].= "<tr>";
            }
            $result[$pageCounter].= "<td bgcolor='white' style='font-size:$fontSizePx;text-align: center;'>";
            if ($showImage) {
                $result[$pageCounter].= "<div style='height: $imageHeight; width:$imageWidth;margin-right: 10px;'>";

                if(strcmp("$imageFile",'')==0){
                    $imageFile = $logoDirectory;
                }
                $img_size_array = getimagesize($imageFile);
                $width = $img_size_array[0];
                $height = $img_size_array[1];

                if($height>$width){
                    $result[$pageCounter].="<img src='$imageURL' style='height: $imageHeight;width:auto'>";
                }else{
                    $result[$pageCounter].="<img src='$imageURL' style='height:auto;width:$imageWidth'>";
                }
                $result[$pageCounter].= "</div>";
            }

            $result[$pageCounter].= "</td >";
            $result[$pageCounter].= "<td bgcolor='white' style='font-size:$fontSizePx;text-align: left;margin-left: 3px;'>";
            $result[$pageCounter].= "<table style='border-color: transparent;' bgcolor='white'>
";

            if ($showName) {
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>Name: </b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'> $item->name</div>
                                                                    </td >
                                                                </tr>";
            }
            if ($showSku) {
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>SKU: </b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'> $item->sku</div>
                                                                </td >
                                                             </tr>";
            }
            if ($showCode) {
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>Code: </b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'> $item->code</div>
                                                                </td>
                                                             </tr>";
            }
            if ($showShortDescription) {
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>Description: </b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'> $item->shortDescription</div>
                                                                </td>
                                                             </tr>";
            }
            if ($showLongDescription) {
                if($showShortDescription){$displayLongName = "";} else {$displayLongName = "Description:";}
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>$displayLongName</b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'> $item->longDescription</div>
                                                                </td>
                                                            </tr>";
            }
            if ($showNumericBarcode) {
                $result[$pageCounter].= "                    <tr>
                                                                <td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'>
                                                                    <div style='text-align: left;$display'><b>Barcode: </b></div>
                                                                </td>
                                                                <td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'>
                                                                    <div style='text-align: left;margin-left:1px;'><div align='left'>$item->barcode</div></div>
                                                                </td >
                                                            </tr>";
            }
            if ($showBarcode && strcmp($item->barcode, '') != 0) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b> </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'><div align='left' style='border: 1px solid black;background-image: linear-gradient(90deg, #ffffff 25%, #000000 25%, #000000 50%, #ffffff 50%, #ffffff 75%, #000000 75%, #000000 100%);background-size: 4.00px 4.00px;'><barcode code='$item->barcode' text='$item->barcode' type='C128B' class='barcode' style='border: 1px solid transparent;width: 100%' /></td ></tr>";
            }
            if ($showStatus) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>Status: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->status</div></td ></tr>";
            }
            if ($showUnits) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>Units: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->uom</div></td ></tr>";
            }
            if ($showPacking) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>Packing: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->packing</div></td ></tr>";
            }
            if ($showSubunits) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>Subunits: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->subunits</div></td ></tr>";
            }
            if ($showVatCode) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>VAT Code: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->vatCode</div></td ></tr>";
            }
            if ($showVatPercent) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>VAT: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'> $item->vatPercentage%</div></td ></tr>";
            }
            if ($showPrice) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>Price: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'><b>$item->unitPrice</b></div></td ></tr>";
            }
            if ($showBothPrices && strcmp($priceTypeID, '') != 0) {
                $result[$pageCounter].= "                    <tr><td bgcolor='white' style='width:auto;font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;$display'><div style='text-align: left;$display'><b>$priceTypeName: </b></div></td><td style='font-size:$fontSizePx;text-align: left;padding: 0px;border-color: transparent;' bgcolor='white'><div style='text-align: left;margin-left:1px;'><b>$item->unitPrice2</b></div></td ></tr>";
            }

            $result[$pageCounter].= "           </table>
                                </td>";

            if ($counter >= $itemsPerRow) {

                $td = $itemsPerRow * $itemsPerRow + 3;
                $result[$pageCounter].= "</tr>
                                         <tr >
                                            <td colspan='$td' style='height: 2px; '></td>
                                         </tr>";
                $result[$pageCounter].= "<tr >
                                            <td colspan='$td' style='height: 2px; ' bgcolor='$borderColor'></td>
                                         </tr>";
                $result[$pageCounter].= "<tr >
                                         <td colspan='$td' style='height: 2px; '></td>
                                         </tr><tr >";

                $counter = 0;
                $rowCounter++;
            } else {
                if (true) {
                    $result[$pageCounter].= "<td style='width: 2px;'>&nbsp;&nbsp;</td><td bgcolor='$borderColor' style='width: 2px;'></td><td style='width: 2px;'>&nbsp;&nbsp;</td>";
                }
                $rowCounter++;
            }
        }
        if($rowCounter % (76*$itemsPerRow+1) == 0){
            $rowCounter = 1;
            $pageCounter++;
        }
    }
    }

    $resultFooter = "</table> </div>";

    $finalFileFooter = "
                    <div style='margin-top: 20px;'>
                    </div>
        
                    <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                        color: #000000;  '><tr>
                        <td width='33%'><span style=''><p class='pull-left' style='color:gray;margin-top:5px;font-size:9px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif;display: inline-block;text-align: left;'> Powered by<br><i style=' font-style: italic;'>Coprime Mobile Commerce.</i></p></td>
                        <td width='33%' align='center' style=''>Page {PAGENO} of {nbpg}</td>
                        <td width='33%' align='right'><div align='right'>$line1 Product Catalogue</div></td>
                        </tr></table></div></div>
                ";



    $return = '';
    $pdfCounter = 0;
    $filesArray = array();

    foreach ($result as $page){

        $page = str_replace('</tr></tr>','</tr>',$page);

        $pdfCounter++;

        if($landScape){
            $mpdf=new mPDF('utf-8', 'A4-L');
        } else {
            $mpdf=new mPDF();
        }

        $mpdf->setAutoTopMargin='stretch';
        $mpdf->setAutoBottomMargin='stretch';
        $mpdf->keep_table_proportions=true;
        $mpdf->WriteHTML($resultHeader.$page.$resultFooter);
        $mpdf->Output("ProductCatalogueExport-$pdfCounter.pdf","F");

        array_push($filesArray,"ProductCatalogueExport-$pdfCounter.pdf");

        $return .= $page;
    }

    if($landScape){
        mergeAndDownloadPDFFiles($filesArray,'ProductCatalogueExport.pdf',$finalFileFooter,new mPDF('utf-8', 'A4-L'));
    } else {
        mergeAndDownloadPDFFiles($filesArray,'ProductCatalogueExport.pdf',$finalFileFooter,new mPDF());
    }

    return $resultHeader.$return.$resultFooter.$finalFileFooter;
}

function getSubCategories($categoryID){

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $result = '';
    if(strcmp($categoryID,'')!=0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT subcategory_id FROM Subcategories WHERE category_id = $categoryID");
        $stm->execute();
        $stm->bind_result($subCategoryID);
        while ($stm->fetch()) {
            $result .= ",$subCategoryID".getSubCategories($subCategoryID);
        }
        $stm->close();
    }
    return $result;
}

function mergeAndDownloadPDFFiles(Array $filenames, $outFile,$footer,$mpdf)
{
    if ($filenames) {

        $filesTotal = sizeof($filenames);
        $fileNumber = 1;

        $mpdf->SetImportUse(); // this line comment out if method doesnt exist

        if (!file_exists($outFile)) {
            $handle = fopen($outFile, 'w');
            fclose($handle);
        }

        foreach ($filenames as $fileName) {
            if (file_exists($fileName)) {
                $pagesInFile = $mpdf->SetSourceFile($fileName);
                for ($i = 1; $i <= $pagesInFile; $i++) {
                    $tplId = $mpdf->ImportPage($i); // in mPdf v8 should be 'importPage($i)'
                    $mpdf->UseTemplate($tplId);
                    $mpdf->SetHTMLFooter($footer);
                    if (($fileNumber < $filesTotal) || ($i != $pagesInFile)) {
                        $mpdf->WriteHTML('<pagebreak />');
                    }
                }
            }
            $fileNumber++;
        }

        $mpdf->Output($outFile,"F");

        foreach (glob("ProductCatalogueExport-*.*") as $filename) {
            unlink($filename);
        }

    }

}

$result = generateProductCatalogue();
echo $result;

