<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Production_Receipt';

// Table's primary key
$primaryKey = "production_receipt_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`pr`.`production_receipt_id`', 'dt' => 'icon', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['tender_id'];
        return '<span style="width: 40px;height: 40px;padding:5px;" class="custom-rounded-image invoice center-canvas"><img  src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/productionreceipticon.png" style="margin-top:6px;width: 100%;height: auto;"   ></span>';},
        'field' => 'production_receipt_id' ),

    array( 'db' => '`pr`.`production_receipt_code`',       'dt' =>  'code', 'field' =>'production_receipt_code' ),
//    array( 'db' => '`pr`.`from_warehouse_id`',       'dt' => 'fromWH', 'field' => 'from_warehouse_id' ),
//    array( 'db' => '`pr`.`to_warehouse_id`',       'dt' => 'toWH' , 'field' => 'to_warehouse_id' ),

    array( 'db' => '`pr`.`from_warehouse_id`', 'dt' => 'fromWH', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT warehouse_code,name FROM Warehouses WHERE warehouse_id='$d'");
        $stm1-> execute();
        $stm1-> bind_result($whFromCode,$whFromName);
        while ($stm1->fetch()) {}
        $stm1->close();
        return "$whFromCode - $whFromName";
    },
        'field' => 'from_warehouse_id' ),


    array( 'db' => '`pr`.`to_warehouse_id`', 'dt' => 'toWH', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT warehouse_code,name FROM Warehouses WHERE warehouse_id='$d'");
        $stm1-> execute();
        $stm1-> bind_result($whToCode,$whToName);
        while ($stm1->fetch()) {}
        $stm1->close();
        return "$whToCode - $whToName";
    },
        'field' => 'to_warehouse_id' ),


    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'formatter' => function( $d, $row ) {
            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {}
            $stm1->close();
            return "$d - $fname $lname";
        },
        'field' => 'salesperson_code' ),
    array( 'db' => '`pr`.`start_date`', 'dt' => 'startDate' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'start_date' ),
    array( 'db' => '`pr`.`end_date`', 'dt' => 'endDate' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'end_date' ),
    array( 'db' => '`pr`.`details`',       'dt' => 'details', 'formatter' => function( $d, $row ) {
        if (strcmp($d,'')==0){
            $details = "<p style='font-size: 20px;'>-</p>";
        }else{
            $details = $d;
        }
        return "$details";}, 'field' => 'details' ),
    array( 'db' => '`pr`.`status`',       'dt' => 'status', 'field' => 'status' ),
    array( 'db' => '`pr`.`production_receipt_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/productions/views/view_production_receipt.php" style="display:inline;" method="post" target="_blank">
                    <input type="hidden" name="production_receipt_id" value="'.$d.'">
                    <input style="font-size:13px;" type="submit" class="btn btn-invoice" value="View" style="width:60px">
			    </form>';},
        'field' => 'production_receipt_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Production_Receipt` AS `pr` LEFT JOIN `SalesPersons` AS `s` ON (`pr`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery)
);

?>