<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

$parentID = $_GET['serviceCallID'];
$joinALL = $_GET['joinall'];

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image monthly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/settingsicon.png" width="30" height="30"></td>';},
        'field' => 'service_call_code' ),
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'code', 'field' => 'service_call_code' ),

    array( 'db' => '`t`.`type_name`', 'dt' => 'type', 'field' => 'type_name' ),
    array( 'db' => '`s`.`date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' =>'date' ),
    array( 'db' => '`s`.`due_date`', 'dt' => 'duedate', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    },'field' => 'due_date' ),
    array( 'db' => '`s`.`topic`', 'dt' => 'topic' , 'field' => 'topic' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'ccode', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'formatter' => function( $d, $row ) {
        $p = $GLOBALS['serviceCallNewID'];
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT color FROM SC_Types,Service_Call WHERE SC_Types.type_id=Service_Call.type_id AND Service_Call.service_call_id='$p' LIMIT 1");
        $stm->execute();
        $stm->bind_result($color);
        while ($stm->fetch()) {

            if(strcmp($color,"")==0)
            {
                $color="#333";
            }

        }
        $stm->close();




        return "<span style='font-weight:bold;color:$color'>$d</span>";}, 'field' => 'customer_company_name' ),

    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'salespersonid', 'field' => 'salesperson_code' ),
    array( 'db' => '`h`.`link_type`', 'dt' => 'linktype', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'Parent')==0){
            return 'Parent/Child';
        } else if (strcmp($d,'Predecessor')==0){
            return 'Pred./Succ.';
        } else {
            return $d;
        }
    }, 'field' => 'link_type' ),
    array( 'db' => '`st`.`status_name`', 'dt' => 'statusid', 'field' => 'status_name' ),
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        $styleEdit = "width:40px;display: inline-block; margin-bottom:1.5px;";
        $style = "width:40px;display: inline-block; margin-bottom:1.5px;";
        $action = "//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php";
        $name='service_call_id';
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        global $parentID;
        $stm = $db->prepare("SELECT COUNT(*) FROM Service_Call_Hierarchy WHERE parent_id='$parentID' AND child_id='$d' AND (link_type='Parent' OR link_type='parent')");
        $stm->execute();
        $stm->bind_result($parentCounter);
        while ($stm->fetch()) {}
        $stm->close();

        $stm = $db->prepare("SELECT COUNT(*) FROM Service_Call_Hierarchy WHERE parent_id='$parentID' AND child_id='$d' AND (link_type='Predecessor' OR link_type='predecessor')");
        $stm->execute();
        $stm->bind_result($predecessorCounter);
        while ($stm->fetch()) {}
        $stm->close();

        if($parentCounter>0) {
            $parentLink = 'onclick="deactivateButtonClicked('.$d.',\'Child\');"';
            $parentClass = 'btn-danger';
            $parentTitle = "Unlink From Child";
        } else {
            $parentLink = 'onclick="activateButtonClicked('.$d.',\'Child\');"';
            $parentClass = 'btn-success';
            $parentTitle = "Link As Child";
        }

        if($predecessorCounter>0) {
            $predecessorLink = 'onclick="deactivateButtonClicked('.$d.',\'Successor\');"';
            $predecessorClass = 'btn-danger';
            $predecessorTitle = "Unlink From Successor";
        } else {
            $predecessorLink = 'onclick="activateButtonClicked('.$d.',\'Successor\');"';
            $predecessorClass = 'btn-success';
            $predecessorTitle = "Link As Successor";
        }

        return '<span style="'.$style.'">
                         <form id="'.$d.'"action="'.$action.'" target="_blank" method="post">
                            <input type="hidden" name="'.$name.'" value="'.$d.'">	           			                   
                            <button style="'.$style.'" type="submit" class="btn btn-blue" title="View SC" style="width:60px"><i class="fa fa-eye"></i></button>
                        </form>
			        </span>
			        <span style="'.$styleEdit.'">
                         <button style="'.$styleEdit.'" type="button" id="parentChild_'.$d.'" class="btn '.$parentClass.'" '.$parentLink.' title="'.$parentTitle.'" style="width:60px" ><i class="fa fa-arrow-down"></i></button>
			        </span>
			        <span style="'.$styleEdit.'">
                         <button style="'.$styleEdit.'" type="button" id="predecessorSuccessor_'.$d.'" class="btn '.$predecessorClass.'" '.$predecessorLink.' title="'.$predecessorTitle.'" style="width:60px" ><i class="fa fa-arrow-right"></i></button>
			        </span>';

            ;},
        'field' => 'service_call_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
require( ROOT.'backend/core/controllers/ssp2.class.php' );

if($parentID!=""&&isset($parentID)  && !$joinALL) {
    $joinQuery = "FROM `Service_Call` AS `s` INNER JOIN `Service_Call_Hierarchy` AS `h` ON (`s`.`service_call_id` = `h`.`child_id`) LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`salesperson_id` = `sa`.`salesperson_id` )";
    $where = " ((link_type='Parent' OR link_type='parent') OR (link_type='Predecessor' OR link_type='predecessor')) AND h.parent_id =".$parentID;
}
else
{
    $joinQuery = "FROM `Service_Call` AS `s` LEFT JOIN `Service_Call_Hierarchy` AS `h` ON (`s`.`service_call_id` = `h`.`child_id`) LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`salesperson_id` = `sa`.`salesperson_id` )";
    $where=" NOT st.visible='no' AND NOT s.service_call_id = '$parentID' GROUP BY s.service_call_id";
}





echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>