<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/modules/settlements/model/settlementActionAttachments.php");
require_once(ROOT . "backend/modules/settlements/model/languageProperties.php");
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);



$serviceCallID=0;
$fromServiceCall=false;

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(isset($_GET['customer_id']) && $_GET['customer_id'] > 0) {
    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    $customerID = $_GET['customer_id'];
    $fromServiceCall = true;

    $dbHelbelCustomer = new DBCustomer();
    $customer = $dbHelbelCustomer->getCustomerByID($customerID);

    $stm = $db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($customerAddressID, $addressCode, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {
        $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;
    }
    $stm->close();

    $customerName = $customer->companyName;
    $customerCode = $customer->customerCode;
    $customerBalance = $customer->balance;

}

if(isset($_GET['service_call_id']))
{
    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");

    $serviceCallID=$_GET['service_call_id'];
    $customerID= $_GET['customer_id'];
    $fromServiceCall=true;

    $dbHelbelCustomer= new DBCustomer();
    $customer=$dbHelbelCustomer->getCustomerByID($customerID);

    $stm = $db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($customerAddressID, $addressCode,$country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {
        $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;
    }
    $stm->close();

    $customerName =  $customer->companyName;
    $customerCode = $customer->customerCode;
    $customerBalance = $customer->balance;


}

if(isset($_GET['receipt_id']))
{

    $receiptID=$_GET['receipt_id'];
    $_POST['receipt_id'] = $receiptID;
    $edit = true;
    $linked=false;
}

if(isset($_POST['receipt_id']))
{

    $receiptID=$_POST['receipt_id'];
    $_SESSION['receipt_id'] = $receiptID;
    $edit = true;
    $linked=false;
} else {
    $edit = false;
    $linked=false;
}

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if($edit) {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,timestamp FROM Receipts WHERE receipt_id='$receiptID'");
    $stm->execute();
    $stm->bind_result($receiptID, $recieptCode, $customerID, $companyID, $salepersonID, $orderID, $invoiceID, $addressID, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes, $status, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");


        $stm2 = $db2->prepare("SELECT  COUNT(*) FROM Invoice_Receipt, Invoices WHERE Invoices.invoice_id = Invoice_Receipt.invoice_id AND receipt_id='$receiptID'");
        $stm2->execute();
        $stm2->bind_result($linkedInvoices);
        while ($stm2->fetch()) {
        }
        $stm2->close();

        if($linkedInvoices > 0){
            $linked=true;
        }else{
            $linked=false;
        }

        $stm3 = $db2->prepare("SELECT customer_code,customer_company_name,balance FROM Customers WHERE customer_id='$customerID'");
        $stm3->execute();
        $stm3->bind_result($customerCode, $customerName, $customerBalance);
        while ($stm3->fetch()) {


        }
        $stm3->close();

        $stm4 = $db2->prepare("SELECT customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_address_id ='$addressID'");
        $stm4->execute();
        $stm4->bind_result($customerAddressID, $addressCode, $acustomerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
        while ($stm4->fetch()) {

            $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;


        }
        $stm4->close();

        $stm5 = $db2->prepare("SELECT CONCAT(salesperson_code ,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id ='$salepersonID'");
        $stm5->execute();
        $stm5->bind_result($salesPersonName);
        while ($stm5->fetch()) {

        }
        $stm5->close();

        $banks = "<option value='$bank' selected>$bank</option>";
        $salesPersons = "<option value='$salepersonID' selected>$salesPersonName</option>";

    }
    $stm->close();

    switch ($paymentMethod) {
        case 'Cash':
            $MethodSelectionCA = 'selected';
            break;
        case 'Cheque':
            $MethodSelectionCH = 'selected';
            break;
        case 'Bank Transfer':
            $MethodSelectionBT = 'selected';
            break;
        case 'Credit Card':
            $MethodSelectionCC = 'selected';
            break;
        case 'Cheque Deposit':
            $MethodSelectionCD = 'selected';
            break;
        case 'Coupon':
            $MethodSelectionCO = 'selected';
            break;
    }
}

if(!$linked) {
    $banks .= "<option value='$bank' selected>$bank</option>";
    $stm = $db->prepare("SELECT name FROM Banks WHERE name NOT LIKE '$bank' ORDER BY name ASC ");
    $stm->execute();
    $stm->bind_result($bankSelect);
    while ($stm->fetch()) {

        $banks .= "<option value='$bankSelect'>$bankSelect</option>";

    }
    $stm->close();
    $banks .= "<option value='Other'>Other Bank</option>";
}



if($linked){
    $disabled = "disabled";
}

if(strcmp($status,'Canceled') == 0){
    $canceled = true;
    $disabled = "disabled";
} else {
    $canceled = false;
}

$includeScLink = false;
$custForm = new CustomForm('Receipts',$receiptID);

if($edit){$actionAttachments = new ActionAttachments('Receipts',$receiptID);}


if(!$edit){
    $adminID = $_SESSION['adminID'];
    if(strcmp($adminID,'')!=0){
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$adminID' OR salesperson_id=0 ORDER BY salesperson_id ASC");
        $stm->execute();
        $stm->bind_result($salespersonID,$salespersonCode,$firstName,$lastName);
        while ($stm->fetch()) {}
        $stm->close();
        if(isset($_SESSION['settlement_language']) && strcmp($_SESSION['settlement_language'],'arabic')==0){
            $tempName = $firstName;
            $firstName = $lastName;
            $lastName = '';
            $disabledReceiptDate = 'disabled readonly';
        }
        $salesPersons = "<option value='$salespersonID' selected>$salespersonCode - $firstName $lastName</option>";

    }

}
$adminID = $_SESSION['adminID'];
$db->set_charset("utf8");
$stm = $db->prepare("SELECT master_user FROM Admin WHERE id='$adminID'");
$stm->execute();
$stm->bind_result($isMaster);
while ($stm->fetch()) {
    if(strcmp(strtolower($isMaster),'yes')!=0){
        $isMaster= 'no';
    }
}
$isMasterUser = false;
if(strcmp($isMaster,'yes')==0){$isMasterUser = true;}
$stm->close();
if($isMaster) {
    $where = '';
    if (isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'], '') != 0) {
        if (strcmp($where, '') != 0) {$where .= " AND ";}
        $where .= " AND salesperson_id IN (" . $_SESSION['Allow_Salespersons'] . ")";
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT salesperson_id,CONCAT(salesperson_code ,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id NOT LIKE '$salepersonID' $where");
    $stm->execute();
    $stm->bind_result($salepersonIDs, $salesPersonNames);
    while ($stm->fetch()) {
        $salesPersons .= "<option value='$salepersonIDs'>$salesPersonNames</option>";
    }
    $stm->close();
}

if(!$edit && $salespersonID > 0){
    $stm = $db->prepare("SELECT email FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($salesPersonCustomer);
    while ($stm->fetch()) {}
    $stm->close();
    $stm = $db->prepare("SELECT customer_id,customer_code,customer_company_name,customer_report_name,balance FROM Customers WHERE customer_code='$salesPersonCustomer' LIMIT 1");
    $stm->execute();
    $stm->bind_result($customerID,$customerCode, $customerName,$customerReportName, $customerBalance);
    while ($stm->fetch()) {}
    $stm->close();

    if(isset($_SESSION['settlement_language']) && strcmp($_SESSION['settlement_language'],'arabic')==0){
        $customerName = $customerReportName;
    }

    $stm = $db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($customerAddressID, $addressCode,$country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {
        $receiptAddress = $addressLine1 . ", " . $addressLine2 . ", " . $city;
    }
    $stm->close();

}

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">
                <?php
                if($edit){
                    echo $editReceiptLabel1;
                } else {
                    echo $addReceiptLabel1;
                }
                ?>
            </li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-6">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image-padding receipt" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/receipticon.png" width="30" height="30">
                    <?php
                    if($edit){
                        echo $editReceiptLabel2;
                    } else {
                        echo $addReceiptLabel2;
                    }
                    ?>
                </h3>
            </div>
            <?php

            if ($fromServiceCall || $hasServiceCall) {
                $scRedirect = " <form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Back To Service Call'/>
                                </form>";
            } else {
                if($edit) {
                    $stm = $db->prepare("SELECT service_call_id FROM Service_Call_Reply WHERE reply_type_id='3' AND document_type='Receipts' AND document_id='$receiptID'");
                    $stm->execute();
                    $stm->bind_result($serviceCallID);
                    while ($stm->fetch()) {
                    }
                    $stm->close();

                    if ($serviceCallID > 0) {
                        $scRedirect = "<form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                    <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                    <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Related Service Call'/>
                                    </form>";
                    } else {
                        if($edit) {
                            $includeScLink = true;
                            include_once(ROOT . "backend/core/model/linkActionToSc.php");
                            $scLink = new linkActionToSc();
                            $scLink->setAction($receiptID,"Receipts");
                            $scRedirect = $scLink->scLinkModal();
                        }
                    }
                }
            }

            if($edit && !$canceled){
                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        <button class='btn btn-danger btn-block' id='cancelReceiptButton' onclick='cancelReceipt($receiptID)'><i class='fa fa-times'></i>&nbsp; $cancelReceiptButtonLabel</button>
                      </div>
                      <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        <form style='margin:0' method='POST' action='//" . HTML_PATH . "/cop/backend/core/templates/pdf/generateReceiptPDF.php' target='_blank' >
                            <input type='hidden' name='receiptID' value='$receiptID'/>
                            <input type='hidden' name='receiptCode' value='$recieptCode'/>
                            <button type='submit' class='show-stat-buttons btn btn-tender btn-block' style='text-transform: capitalize;' id='invoicePDFButton' ><i class='fa fa-file-pdf-o'></i>&nbsp; $pdfButtonLabel</button>
                        </form>
                      </div>";
            } else {
                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'></div>
                      <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                        
                      </div>";
            }
            ?>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons">
                <?php
                if($canceled){
                    echo "<h4 style='color: firebrick;'><b>$receiptCanceledLabel</b></h4>";
                } else {
                    if ($edit && $linked) {
                        echo '<button id="saveButton" onclick="unlinkReceipt();" class="btn btn-primary btn-block"> Unlink Invoices</button>';
                    } else {
                        echo '<button id="saveButton" onclick="saveReceipt();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; '.$saveReceiptButtonLabel.'</button>';
                    }
                }
                ?>
                 </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2></h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body">
                                <?php if($linked && !$canceled){
                                    echo ' <header>
                            
                            <h3 style="color: firebrick">The current receipt is linked with Invoice Documents therefore the editing feature is not allowed.<br/> In order to make any changes you will need to Unlink Invoices </h3>
                        </header>';
                                }?>
                                <form action="" id="checkout-form" class="smart-form" <?php if($canceled){echo 'style="background-color: firebrick"';}?>>
                                    <fieldset>

                                        <div class="row">
                                            <section class="col col-4">
                                                <section>
                                                    <img class="custom-rounded-image-padding receipt" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/receipticon.png" width="30" height="30">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle"> <?php echo $receiptDetailsLabel?></h1>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" ><?php echo $receiptNumberLabel; ?> </label>
                                                    <input type="text"   id="receiptCode" name="receiptCode" class="form-control text-center" value="<?php if($edit) {echo $recieptCode;}?>" style="width: 50%;display: inline-block;" value readonly <?php echo $disabled?>/>
                                                    <input type="hidden" id="receiptID" name="receiptID" value="<?php if($edit) {echo $receiptID;}?>" />
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" ><?php echo $salespersonLabel; ?> </label>
                                                    <select id="salesperson" name="salesperson" class="form-control"  style="width: 50%;display: inline-block;"  <?php if($salespersonID > 0){echo 'disabled readonly';} ?>>
                                                        <?php echo $salesPersons ?>
                                                    </select>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" ><?php echo $receiptDateLabel; ?></label>
                                                    <input type="date" id="receiptDate" name="receiptDate" class="form-control" value="<?php if($edit) {echo $receiptDate;} else {echo date("Y-m-d");}?>"  <?php if($edit){echo 'min="'.$receiptDate.'"';}else{echo 'min="'.date('Y-m-d').'"';}?> style="width: 50%;display: inline-block;" <?php echo $disabled.' '.$disabledReceiptDate; ?>/>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" ><?php echo $paymentMethodLabel; ?></label>
                                                    <select id="paymentMethod" name="paymentMethod" class="form-control"  style="width: 50%;display: inline-block;"  <?php echo $disabled?>>
                                                        <option value="Cash"           <?php if($edit) {echo $MethodSelectionCA;} ?> >Cash Deposits    </option>
                                                        <option value="Cheque"         <?php if($edit) {echo $MethodSelectionCH;} ?> >Cheques          </option>
                                                        <option value="Cheque Deposit" <?php if($edit) {echo $MethodSelectionCD;} ?>>Cheque Deposits  </option>
                                                        <option value="Bank Transfer"  <?php if($edit) {echo $MethodSelectionBT;} ?>>Bank Transfer    </option>


                                                    </select>
                                                </section>

                                                <section >
                                                    <label class="label-bold form-label-space" ><strong><?php echo $receiptAmountLabel; ?></strong></label>
                                                    <input type="number" id="amount" name="amount" min="0.01" class="form-control" placeholder="0.00" value="<?php if($edit) {echo number_format($amount,2);}?>" style="width: 50%;display: inline-block;" step="0.01"  <?php echo $disabled?>/>
                                                </section>
                                                <section style="display: none;" >
                                                    <label class='label-bold form-label-space'><strong> Cash Discount: </strong></label>
                                                    <input type="number" id="cashDiscount" name="cashDiscount" min="0.01" class="form-control" placeholder="0.00" value="<?php if($edit) {echo number_format($cashDiscount,2);}?>" style="width: 50%;display: inline-block;" step="0.01"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"><?php echo $notesLabel; ?></label>
                                                    <textarea id="notes" name="notes" class="form-control"  style="width: 83%;" rows="4"  <?php echo $disabled?>><?php if($edit) {echo str_replace("null","",$notes);}?></textarea>

                                                </section>



                                            </section>
                                            <section class="col col-4" style="padding-left:20px;padding-right:0px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="40" height="40">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle"> <?php echo $customerDetailsLabel; ?></h1>
                                                    <input type='hidden' name='serviceCallID' id="serviceCallID" value='<?php echo $serviceCallID;?>'/>
                                                </section>
                                                <section style="margin-bottom: 20px;">
                                                    <label class="label-bold form-label-space" ><?php echo $findCustomerLabel; ?>  </label>
                                                    <input class='text-center form-control' id='customerSearch' name='customerSearch' style="width: 60%;display: inline-block;"  type='text' value='<?php if($edit||$fromServiceCall||$customerID>0) { echo "$customerCode - $customerName";}?>'  <?php if($customerID>0){echo 'disabled readonly';} ?>>
                                                    <input type="hidden" id="customerID" value="<?php if($edit||$fromServiceCall||$customerID>0) {echo $customerID;}?>" />
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" ><?php echo $customerCodeLabel; ?> </label>
                                                    <label class="label-text" id="customerCode"><?php if($edit||$fromServiceCall||$customerID>0) {echo $customerCode;}?> </label>
                                                </section>

                                                <section >
                                                    <label class="label-bold form-label-space"> <?php echo $customerNameLabel; ?> </label>
                                                    <label class="label-text" id="customerName"> <?php if($edit||$fromServiceCall||$customerID>0) {echo $customerName;}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"> <?php echo $customerBalanceLabel; ?> </label>
                                                    <label class="label-text" id="customerBalance"> <?php if($edit||$fromServiceCall||$customerID>0) {echo number_format($customerBalance,2,'.',',');}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold  form-label-space" ><?php echo $receiptAddressLabel; ?> </label>
                                                    <select class="form-control" id="receiptAddress" name="receiptAddress" style="width: 60%;display: inline-block;"  <?php if($customerID>0){echo 'disabled readonly';} ?>>
                                                        <option value="<?php if($edit||$fromServiceCall||$addressID>0) {echo $addressID;}?>"><?php if($edit||$fromServiceCall||$addressID>0) {echo $receiptAddress;}?></option>
                                                    </select>
                                                </section>

                                            </section>
                                            <section class="col col-4 no-margin" style="padding-left:20px;">
                                                <section style="margin-bottom: 20px;">
                                                    <h1 style="display: inline;vertical-align: middle;" id="chequeTransferDetails"><?php echo $chequeDetailsLabel; ?></h1>
                                                </section>

                                                <section >
                                                    <label class='label-bold form-label-space' > <?php echo $bankLabel; ?> </label>
                                                    <select id='bank' name='bank' class='form-control'style="width: 50%;display: inline-block;"  <?php echo $disabled?>>
                                                        <?php echo $banks?>
                                                    </select>
                                                </section>
                                                <section class="otherBank">
                                                    <label class='label-bold form-label-space' > <?php echo $bankNameLabel; ?> </label>
                                                    <input type="text" id="otherBank" name="otherBank" class="form-control" value="" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class='label-bold form-label-space' > <?php echo $branchLabel; ?> </label>
                                                    <input type="text" id="branch" name="branch" class="form-control" value="<?php if($edit) {echo $branch;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>
                                                <section >
                                                    <label class='label-bold form-label-space' > <?php echo $chequeNumberLabel; ?> </label>
                                                    <input type="number" id="chequeNumber" name="chequeNumber" class="form-control" value="<?php if($edit) {echo $chequeNumber;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section >
                                                <section >
                                                    <label class='label-bold form-label-space'> <?php echo $chequeDateLabel; ?></label>
                                                    <input type="date" id="chequeDate" name="chequeDate" class="form-control" value="<?php if($edit) {echo $chequeDate;}?>" style="width: 50%;display: inline-block;"  <?php echo $disabled?>/>
                                                </section>
                                </form>


                                                <!-- Custom Fields-->
                                                <section>
                                                    <?php

                                                    if($edit){$actionAttachments->attachmentsForm();}

                                                    if($canceled){
                                                        $custForm->disabledCustomFormValues();
                                                    } else {
                                                        $custForm->editCustomFormValues();
                                                    }
                                                    ?>

                                                </section>
                                                <!-- Custom Fields/-->

                                            </section>


                                        </div>

                                    </fieldset>

                            </div>
                            <!-- end widget content -->


                        <!-- end widget div -->


                    <!-- end widget -->



                <!-- NEW WIDGET START -->



                        <!-- widget div-->

                            <!-- widget content -->
                            <?php if(!$canceled && false){

                            echo '
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:5%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%" >
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:12%">
                                            
                                        </th>
                                        <th class="hasinput" style="width:10%">

                                        </th>
                                        <th class="hasinput" style="width:14%">

                                        </th>
                                        <th class="hasinput" style="width:10%">

                                        </th>
                                        <th class="hasinput" style="width:14%">

                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center"></th>
                                        <th class="text-center">Invoice Code</th>
                                        <th class="text-center">Invoice Date</th>
                                        <th class="text-center" data-hide="phone">Salesperson</th>
                                        <th class="text-center" data-hide="phone">Invoice Type</th>
                                        <th class="text-center" data-hide="phone,tablet">Grand Total</th>
                                        <th class="text-center" data-hide="phone,tablet">Status</th>
                                        <th class="text-center" data-hide="phone,tablet">Remaining</th>
                                        <th class="text-center" data-hide="phone,tablet">Actions</th>
                                    </tr>
                                    </thead>
                                </table>

                            </div>
                            '; }
                            ?>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
            </div>

            <!-- end row -->


        </section>

    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function inputValidation()
    {

        var valid  = false;
        var amount = $('#amount').val();

        if($("#actionAttachmentsFileUploaded").length > 0 && $("#actionAttachmentsFileUploaded").val() !== 'yes'){highlightDataError($('#ActionAttachments')); return false;}

        if($("#receiptDate").val() != '' && $("#amount").val() != '' && $("#customerID").val() != '' && amount > 0.009){

            var method = $("#paymentMethod").val();
            var bank   = $("#bank").val();
            var other  = 'Other';
            var cheque = 'Cheque';
            var deposit = 'Cheque Deposit';

            if(method.localeCompare(cheque) == 0 || method.localeCompare(deposit) == 0){

                if($("#bank").val() != '' && $("#chequeNumber").val() != '' && $("#chequeDate").val() != ''){

                    if (bank.localeCompare(other) != 0) {
                        valid = true;
                    } else {
                        if(bank.localeCompare(other) == 0 && $("#otherBank").val() != ''){
                            valid = true;
                        } else {
                            valid = false;

                            highlightDataError($('#otherBank'));
                        }
                    }

                } else {
                    valid = false;

                    var bank =$('#bank').val();
                    var chequeNumber =$('#chequeNumber').val();
                    var chequeDate =$('#chequeDate').val();

                    if(!bank){highlightDataError($('#bank'));}
                    if(!chequeNumber){highlightDataError($('#chequeNumber'));}
                    if(!chequeDate){highlightDataError($('#chequeDate'));}
                }

            } else {
                valid = true;
            }

        } else {
            valid = false;

            var customerID =$('#customerID').val();
            var receiptDate =$('#receiptDate').val();
            var amount =$('#amount').val();

            if(!customerID){highlightDataError($('#customerSearch'));}
            if(!receiptDate){highlightDataError($('#receiptDate'));}
            if(!amount || amount <= 0.009){highlightDataError($('#amount'));}
        }

        return valid;
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }

    function saveReceipt()
    {
        $("#saveButton").attr("disabled", true);

        var valid = inputValidation();

        if(valid){

            var checkedInvoices = [];
            $("input[name='invoice']:checked").each(
                function(){
                    var id = this.id;
                    checkedInvoices.push(id);
                }
            );


            var bank           = $('#bank').val();
            var notes          = $('#notes').val();
            var branch         = $('#branch').val();
            var amount         = $('#amount').val();
            var receiptID      = $('#receiptID').val();
            var otherBank      = $('#otherBank').val();
            var chequeDate     = $('#chequeDate').val();
            var customerID     = $('#customerID').val();
            var receiptCode    = $('#receiptCode').val();
            var salesperson    = $('#salesperson').val();
            var receiptDate    = $('#receiptDate').val();
            var chequeNumber   = $('#chequeNumber').val();
            var cashDiscount   = $('#cashDiscount').val();
            var paymentMethod  = $('#paymentMethod').val();
            var receiptAddress = $('#receiptAddress').val();
            var serviceCallID  = $('#serviceCallID').val();
            <?php $custForm->declareJsonVariables();?>


            if(otherBank){
                bank = otherBank;
            }

            $.ajax({
                type: "POST",

                <?php
                if($edit)
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_receipt.php',";
                }
                else
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_receipt.php',";
                }
                ?>

                data: {
                    'bank'           : bank,
                    'notes'          : notes,
                    'branch'         : branch,
                    'amount'         : amount,
                    'receiptID'      : receiptID,
                    'chequeDate'     : chequeDate,
                    'customerID'     : customerID,
                    'salesperson'    : salesperson,
                    'receiptCode'    : receiptCode,
                    'receiptDate'    : receiptDate,
                    'chequeNumber'   : chequeNumber,
                    'cashDiscount'   : cashDiscount,
                    'paymentMethod'  : paymentMethod,
                    'serviceCallID'  : serviceCallID,
                    'receiptAddress' : receiptAddress,
                    'checkedInvoices': checkedInvoices
                    <?php $custForm->passJsonVariables();?>
                },

                success: function (result) {

                    $.smallBox({
                        title: "Success!",
                        content: "Receipt successfully created",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/settlements/views/create_settlement_receipt.php?receipt_id=" + result);
                }

            });

        } else {

            $.smallBox({
                title: "Error!",
                content: "Please complete Receipt data",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
            $("#saveButton").attr("disabled", false);

        }



    }

    function initCustomerCodeAutocomplete()
    {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {

                var bal = parseFloat(ui.item.balance).toFixed( 2 );

                $('#customerID').val(ui.item.id);
                $('#datatable_fixed_column').DataTable().ajax.reload();
                $('#customerCode').text(ui.item.customer_code);
                $('#customerName').text(ui.item.customer_company_name);
                $('#customerBalance').text(bal);

                var optionsAsString = "";
                for(var i = 0; i < ui.item.addresses.length; i++) {
                    if(i==0)
                    {
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + ", " + ui.item.addresses[i].addressLine2 + ", " + ui.item.addresses[i].city + "</option>";
                    }
                    else{
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + ", " + ui.item.addresses[i].addressLine2 + ", " + ui.item.addresses[i].city + "</option>";
                    }
                }
                $("select[name='receiptAddress']").find('option').remove().end().append($(optionsAsString));
                return true;
            }

        });
    }

    function viewPDF(url)
    {
        if(urlExists(url))
        {
            window.open(url, '_blank');
        }
        else
        {
            alert("PDF not created on the Mobile Device, please create the PDF and then sync to the Cloud");
        }
    }

    function urlExists(url)
    {
        var http = new XMLHttpRequest();
        http.open('HEAD', url, false);
        http.send();
        return http.status!=404;
    }

    function initPaymentMethodCheck()
    {
        var method = $("#paymentMethod").val();
        var cheque = 'Cheque';
        var bankTransfer = 'Bank Transfer';
        var deposit = 'Cheque Deposit';

        if(method.localeCompare(cheque) == 0 || method.localeCompare(deposit) == 0){

            initOtherBankCheck();
            $('#chequeTransferDetails').html('<?php echo $chequeDetailsLabel; ?>');
            $('#bank').val("");
            $('#bank option:selected').remove();
            $("#bank").val($("#bank option:first").val());
            $('#bank').attr("disabled", false);
            $("#branch").prop('readonly', false);
            $("#chequeNumber").prop('readonly', false);
            $("#chequeDate").prop('readonly', false).val('<?php echo date('Y-m-d');?>');
            $("#ActionAttachments").show();
            $("#TabAttachments").hide();

        } else if(method.localeCompare(bankTransfer) == 0){

            initOtherBankCheck();
            $('#chequeTransferDetails').html('<?php echo $bankTransferDetailsLabel; ?>');
            $('#bank').val("");
            $('#bank option:selected').remove();
            $("#bank").val($("#bank option:first").val());
            $('#bank').attr("disabled", false);
            $("#branch").prop('readonly', false);
            $("#chequeNumber").val(null).prop('readonly', true);
            $("#chequeDate").val(null).prop('readonly', true);
            $("#ActionAttachments").hide();
            $("#TabAttachments").hide();

        } else {
            $('#chequeTransferDetails').html('<?php echo $chequeDetailsLabel; ?>');
            $('#bank').attr("disabled", true).append(`<option value=""></option>`).val("");
            $("#branch").val(null).prop('readonly', true);
            $("#chequeNumber").val(null).prop('readonly', true);
            $("#chequeDate").val(null).prop('readonly', true);
            $("#ActionAttachments").hide();
            $("#TabAttachments").hide();
        }
        initOtherBankCheck();
    }

    function initOtherBankCheck()
    {

        var bank  = $("#bank").val();
        var other = 'Other';

        if(bank.localeCompare(other) == 0){
            $("#otherBank").prop('readonly', false);
            $(".otherBank").prop('hidden', false);
        } else {
            $("#otherBank").val('');
            $("#otherBank").prop('readonly', true);
            $(".otherBank").prop('hidden', true);
        }
    }

    function unlinkReceipt(){
        var receiptid = $('#receiptID').val();

        $("#cancelReceiptButton").hide();

        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/unlinkReceiptInvoices.php",
            data: {receiptID:receiptid},
            success: function(result){
                $.smallBox({
                    title : "Success!",
                    content : "Invoices Successfully Unlinked",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });
                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/settlements/views/create_settlement_receipt.php?receipt_id="+result);
            }});
    }

    function cancelReceipt(receiptID){
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/modules/settlements/controllers/cancelSettlementReceipt.php",
            data: {receiptID:receiptID},
            success: function(result){
                $.smallBox({
                    title : "Success!",
                    content : "Receipt Successfully Cancelled",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });
                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/settlements/views/create_settlement_receipt.php?receipt_id="+receiptID);
            }});
    }

    <?php if($includeScLink){echo $scLink->linkScFunction();} ?>

    $(document).ready(function() {

        pageSetUp();
        initCustomerCodeAutocomplete();
        initOtherBankCheck();
        <?php if(!$linked){echo 'initPaymentMethodCheck();';}?>

        <?php
        if(strcmp(strtolower($status),'canceled')==0 || strcmp(strtolower($status),'cancelled')==0){
            echo '$("#main :input").attr("disabled", true);';
            echo '$("#main").css("background-color", "#F3CFC6");';
            echo '$("#newLineButton").attr("disabled", true);';
        }

        ?>

        $("#paymentMethod").change(function(){  initPaymentMethodCheck(); });

        $("#bank").change(function(){ initOtherBankCheck(); });


        $("#chooseParentSelect").select2({
            placeholder: "No Parent Selected",
            allowClear: true

        });

        var responsiveHelper_dt_basic = undefined;
        var responsiveHelper_datatable_fixed_column = undefined;
        var responsiveHelper_datatable_col_reorder = undefined;
        var responsiveHelper_datatable_tabletools = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };


        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "t"+ "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,
            "order": [[ 4, "desc" ]],
            "processing": false,
            "serverSide": true,

            "ajax":{
                 type: "POST",
                <?php
                if($linked || $canceled){
                    echo 'url : "//' . HTML_PATH . '/cop/backend/core/controllers/getAll/getAllLinkedInvoicesToReceipt.php",';
                    echo "data: function ( d ) { d.receiptID = $('#receiptID').val();}";
                } else {
                    echo 'url : "//' . HTML_PATH . '/cop/backend/core/controllers/getAll/getAllInvoicesForReceipts.php",';
                    echo "data: function ( d ) { d.customerID = $('#customerID').val();}";
                }
                ?>


            },

            "columns": [
                { "data": "img" },
                { "data": "code" },
                { "data": "date" },
                { "data": "salesperson" },
                { "data": "type" },
                { "data": "grand" },
                { "data": "status" },
                { "data": "remaining" },
                { "data": "form" }
            ],
            "deferRender": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }

        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();

        } );
        /* END COLUMN FILTER */

        <?php if($includeScLink){echo $scLink->initScDataTable();} ?>
        <?php if($edit){$actionAttachments->attachmentsDropzone(true);}?>



    })

</script>



