<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Truck_Type_Trucks';

// Table's primary key
$primaryKey = "truck_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`tr`.`truck_id`', 'dt' => 'truck_id', 'formatter' => function( $d, $row ) {$GLOBALS['truck_id ']=$d;return $d;}, 'field' => 'truck_id' ),
    array( 'db' => '`tr`.`truck_code`', 'dt' => 'code', 'field' => 'truck_code' ),
    array( 'db' => '`tr`.`truck_name`', 'dt' => 'name', 'field' => 'truck_name' ),
    array( 'db' => '`t`.`truck_type_name`', 'dt' => 'type', 'field' => 'truck_type_name' ),
    array( 'db' => '`tr`.`status`', 'dt' => 'active', 'formatter' => function( $d, $row ) {
        $GLOBALS['status']=$d;
        if(strcmp($d,"yes")==0){
            return '<center><div class="label-success" style="text-align: center;width: 33px;height: 33px;padding-top: 7.5px;border-radius: 50%;color: white"><b>Yes</b></div></center>';
        }else{
            return '<center><div class="label-danger" style="text-align: center;width: 33px;height: 33px;padding-top: 7.5px;border-radius: 50%;color: white"><b>No</b></div></center>';
        }
    }, 'field' => 'status' ),
    array( 'db' => '`tr`.`truck_id`',       'dt' => 'actions' , 'formatter' => function( $d, $row ) {
        $status = $GLOBALS['status'];
        $buttons = "";


        if(strcmp($status,"no")==0) {
            $buttons .= "<button type=\"button\" class=\"btn btn-danger\" onclick=\"deleteTruck('$d');\" style=\"display: inline;margin: 1px;\" >Remove</button>";
        }
        if(strcmp($status,"yes")==0) {
            $buttons .= "<button type=\"button\" class=\"btn btn-orange\" onclick=\"changeTruckStatus('$d','no');\" style=\"display: inline;margin: 1px;\" >Deactivate</button>";
        } else if (strcmp($status,"no")==0) {
            $buttons .= "<button type=\"button\" class=\"btn btn-success\" onclick=\"changeTruckStatus('$d','yes');\" style=\"display: inline;margin: 1px;\" >Activate</button>";
        }

        return 	$buttons;
    }, 'field' => 'truck_id' )

);
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Truck_Type_Trucks` AS `tr` LEFT JOIN `Truck_Types` AS `t` ON (`tr`.`truck_type_id` = `t`.`truck_type_id`)";
$where="";

if(isset($_GET['type']) && $_GET['type']!="" && $_GET['type'] > 0){
    if(strcmp($where,"")!=0){$where .=" AND ";}
    $where .="`t`.`truck_type_id`='".$_GET['type']."'";
}



//$where ="`a`.`primary_address`='yes'";
require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>