<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 11:09
 */
require_once(ROOT . "backend/core/model/Customer.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
require_once(ROOT . "backend/core/model/ContactPerson.php");
require_once(ROOT . "backend/core/model/ContractPrices.php");
require_once(ROOT . "backend/core/model/CustomerGroup.php");
require_once(ROOT . "backend/core/model/Contract.php");
//include_once("../../../param.php");

class DBCustomer {

    public $db;

    static private $instance;

    public function __construct()
    {
        $this->db = new mysqli(localhost,username,password,database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
    }

    static public function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new DBCustomer();
        }
        return self::$instance;
    }

    public function getCustomerByID($customerID)
    {
        $customer=null;
        $stm = $this->db->prepare("SELECT customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance,$timestamp);
        while ($stm->fetch()) {
            $customer = new Customer($customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance);

        }
        $stm-> close();
        return $customer;
    }

    public function getSupplierByID($customerID)
    {
        $customer=null;
        $stm = $this->db->prepare("SELECT customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance,$timestamp);
        while ($stm->fetch()) {
            $customer = new Customer($customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance);

        }
        $stm-> close();
        return $customer;
    }

    public function getCustomerAddress($customerID)
    {
        $customerAddresses= array();

        $stm =$this->db->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($customerAddressID,$addressCode,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress,$timestamp);
        while ($stm->fetch()) {

             $customerAddress= new CustomerAddress($customerAddressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress);
            array_push($customerAddresses,$customerAddress);


        }
        $stm-> close();
        return $customerAddresses;
    }

    public function getContactPersonsOfCustomer($customerID)
    {
        $contactPersons= array();
        $stm = $this->db->prepare("SELECT contact_person_id,first_name,last_name,position,landline,mobile,fax,email,notes,timestamp FROM Contact_Person WHERE customer_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($contactPersonID,$firstName,$lastName,$position,$landline,$mobile,$fax,$email,$notes,$timestamp);
        while ($stm->fetch()) {

            $contactPerson = new ContactPerson($contactPersonID,$firstName,$lastName,$position,$landline,$mobile,$fax,$email,$notes);
            array_push($contactPersons,$contactPerson);


        }
        $stm-> close();

        return $contactPersons;
    }

    public function getContractPrices($customerID)
    {
        $contractPrices= array();
        $stm = $this->db->prepare("SELECT customer_id,item_id,price,valid_until,timestamp FROM ContractPrices WHERE customer_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($customerID,$itemID,$price,$validUntil,$timestamp);
        while ($stm->fetch()) {

            $contractPrice = new ContractPrices($customerID,$itemID,$price);
            array_push($contractPrices,$contractPrice);
        }
        $stm-> close();

        return $contractPrices;
    }


    public function getCustomerGroups($customerID)
    {
        $groupIDs= array();
        $stm = $this->db->prepare("SELECT group_id FROM Customer_CustomersGroup WHERE customer_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($groupID);
        while ($stm->fetch()) {


            array_push($groupIDs,$groupID);
        }
        $stm-> close();

        return $groupIDs;
    }

    public function getContract($contractID)
    {
        $contract=null;
        $stm = $this->db->prepare("SELECT contract_id, customer_id, customer_address_id, item_id, serial_number_id, salesperson_id, contract_type_id, serial_number_transaction_log_id, start_date, end_date, price, due_date, valid, payment_type_id, payment_date, way_of_payment_id, technician_id, attachment_id, notes, troubleshooting_id,date_of_purchase,price2,price3,total1,total2 FROM Contracts WHERE contract_id ='$contractID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($contractID,$customerID,$customerAddressID,$itemID,$serialNumberID,$salespersonID,$contractTypeID,$serialNumberTransactionLog,$startDate,$endDate,$price,$dueDate,$valid,$paymentTypeID,$paymentDate,$wayOfPaymentID,$technicianID,$attachmentID,$notes,$troubleshootingID,$dateOfPurchase,$price2,$price3,$total1,$total2);
        while ($stm->fetch()) {
            $contract = new Contract($contractID,$customerID,$customerAddressID,$itemID,$serialNumberID,$salespersonID,$contractTypeID,$serialNumberTransactionLog,$startDate,$endDate,$price,$dueDate,$valid,$paymentTypeID,$paymentDate,$wayOfPaymentID,$technicianID,$troubleshootingID,$notes,$dateOfPurchase,$price2,$price3,$total1,$total2);




        }
        $stm-> close();

        return $contract;
    }
    public function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
    {

        $value="";
        $stm = $this->db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($value);
        while ($stm->fetch()) {


        }
        $stm-> close();

        return $value;
    }

    public function getPriceList($customerID)
    {
        $priceListID=null;
        $stm = $this->db->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id ='$customerID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($priceListID);
        while ($stm->fetch()) {


        }
        $stm-> close();
        return $priceListID;
    }

    public function getPrimaryCustomerAddress($customerID)
    {

        $customerAddresses="";
        $stm =$this->db->prepare("SELECT address_line_1,address_line_2,postcode,country,city FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address='yes'");
        $stm-> execute();
        $stm-> bind_result($addressLine1,$addressLine2,$postcode,$country,$city);
        while ($stm->fetch()) {

            $customerAddresses =$addressLine1." ".$addressLine2." ".$postcode." ".$city." ".$country;

        }
        $stm-> close();
        return $customerAddresses;
    }

}