<?php
require_once('../../../backend/core/model/Stock.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Warehouse.php');


function inboundStock($db, $client)
{
    $filters = array('Company' => $client->getCompanyCode());
    $filters = json_encode($filters);

    $response = $client->requestData('StockAvailability',$filters);

    foreach ($response->ItemAvailStockList as $data) {

        $stockItem = $db->getItemObjectByCode("$data->ItemCode");
        $stockWarehouse = $db->getWarehouseObjectByCode("$data->Store");


        $stock = new Stock(
            $item = $stockItem,
            $warehouse = $stockWarehouse,
            $batchNumber = "0",
            $available = "$data->AvailQty",
            $reserved = "",
            $delivered = "",
            $onOrder = "",
            $requested = "",
            $sold = "",
            $expiryDate = ""
        );

        $excludeUpdateColumns = array(
            'Stock' => array('reserved', 'delivered', 'on_order', 'requested', 'sold', 'expiry_date')
        );


        $deleteRecordsNotSent = array();

        $client->log($db->insertUpdateStockByObject($stock, $excludeUpdateColumns, $deleteRecordsNotSent));


    }
    $client->complete();
}

?>