<?php
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/CustomerAddress.php');
require_once('../../../backend/core/model/CustomerGroup.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/Schedule.php');
require_once('../../../backend/core/model/ScheduleCustomer.php');

function inboundCustomers($db,$client){

    $response = $client->requestData('CUSTOMERS');

    foreach ($response->value as $data){

        $typeOfBusinessValue = 'Credit';
        if(strcmp($data->STATDES,'Inactive')==0){$typeOfBusinessValue=$data->STATDES;}


        $customer = new Customer(
            $customerID          = "",
            $customerCode        = "$data->CUSTNAME",
            $companyName         = "$data->CUSTDES",
            $reportName          = "$data->CUSTDESLONG",
            $logo                = "",
            $registrationCode    = "",
            $mobile              = "$data->PHONE",
            $website             = "",
            $email               = "$data->EMAIL",
            $description         = "$data->PAYDES",
            $typeOfBusiness      = "$typeOfBusinessValue",
            $ticCode             = "",
            $vatCode             = "$data->TAXCODE",
            $creditLimit         = "$data->MAX_CREDIT",
            $typeOfCustomer      = "Credit",
            $balance             = "",
            $addressCodeEurosoft = "$data->BUSINESSTYPE"
        );


        $customer->addCustomerAddress(
            new CustomerAddress(
                $addressID      = "",
                $addressCode    = "$data->CUSTNAME",
                $customerID     = "",
                $country        = "$data->COUNTRYNAME",
                $city           = "$data->STATEA",
                $addressLine1   = "$data->ADDRESS",
                $addressLine2   = "",
                $postcode       = "$data->ZIP",
                $region         = "$data->STATENAME",
                $lat            = "",
                $lng            = "",
                $pobox          = "",
                $landline       = "$data->PHONE",
                $fax            = "$data->FAX",
                $primaryAddress = "yes"
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->AGENTCODE)),
                $name        = "$data->AGENTCODE",
                $description = "AGENTCODE",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->BUSINESSTYPE)),
                $name        = "$data->BUSINESSTYPE",
                $description = "BUSINESSTYPE",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC1)),
                $name        = "$data->SPEC1",
                $description = "SPEC1",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC2)),
                $name        = "$data->SPEC2",
                $description = "SPEC2",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC3)),
                $name        = "$data->SPEC3",
                $description = "SPEC3",
                $creationDate = date('Y-m-d')
            )
        );


        $excludeUpdateColumns = array(
            'Customers'       => array('balance'),
            'CustomerAddress' => array('lat','lng'),
            'CustomerGroups'  => array()
        );


        $deleteRecordsNotSent = array(
            'CustomerAddress' => true,
            'CustomerGroups'  => true
        );

//        $client->log($db->insertUpdateCustomerByObject($customer,$excludeUpdateColumns,$deleteRecordsNotSent),'CUSTOMERS');
//
//
//        $paymentType = new PaymentType(
//            $paymentTypeID   = "",
//            $paymentTypeCode = "$data->PAYCODE",
//            $name            = "$data->PAYDES"
//        );
//
//        $client->log($db->insertUpdatePaymentTypeByObject($paymentType,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()));

        $scheduleResponse = $client->requestData("CUSTOMERS('$data->CUSTNAME')/DEXT_CUSTWEEKDAY_SUBFORM");

        foreach ($scheduleResponse->value as $scheduleData){

            if((int)$scheduleData->WEEKDAY == 1){$dayNumber = 7 ;}
            else {$dayNumber = (int)$scheduleData->WEEKDAY - 1 ;}

            $schedule = new Schedule(
                $scheduleID   = "",
                $name         = $db->getDayNameByNumber($dayNumber)."",
                $creationDate = date('Y-m-d'),
                $creatorID    = "1",
                $type         = "Custom",
                $date         = date('Y-m-d'),
                $repeatPeriod = "1",
                $day          = "$dayNumber",
                $week         = "0",
                $month        = "0",
                $notes        = "",
                $scheduleCustomers = array()
            );

            $schedule->addScheduleCustomer(
                new ScheduleCustomer(
                    $scheduleCustomerID = "",
                    $scheduleID = "",
                    $customerID = "".$db->getCustomerObjectByCode("$data->CUSTNAME")->customerID,
                    $position = "1",
                    $appointmentTime = "$scheduleData->FROMTIME - $scheduleData->TOTIME"
                )
            );

            $excludeUpdateColumns=array(
                'Schedules' => array('creation_date','date'),
                'Schedule_Customer' => array('position')

            );
            $deleteRecordsNotSent=array('Schedule_Customer'=>true);

//            $client->log($db->insertUpdateScheduleByObject($schedule,$excludeUpdateColumns,$deleteRecordsNotSent));

        }
        break;
    }

    $client->complete();
}


?>