<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Receipt.php');
require_once('../../../backend/core/model/ReceiptItem.php');
require_once('../../../backend/core/model/Bank.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/DocumentStatus.php');


function outboundReceipts($db, $client)
{
    $receipts = $db->getDocumentForExports("Receipts", true, "AND receipt_id=20011 ");

    foreach ($receipts as $receipt){

        $data = new stdClass();
        $data->ACCNAME      = $db->getCustomerObjectByID($receipt->customerID)->customerCode;
        $data->IVDATE       = $receipt->receiptDate;
        $data->BOOKNUM      = $receipt->receiptCode;
        $data->DETAILS      = $receipt->notes;
        $data->TFNCITEMS    = array();

        $invoices = $db->getInvoicesOfReceiptByID($receipt->receiptID);

        foreach($invoices as $receiptInvoice){
            $tfncItem = new stdClass();
            $tfncItem->CREDIT = $receiptInvoice->amount;
            $tfncItem->IVCODE = "INV";
            $tfncItem->FNCIREF1 = $receiptInvoice->invoiceCode;

            array_push($data->TFNCITEMS,$tfncItem);
        }

        if(strcmp($receipt->paymentMethod,'Cash')==0){
            $data->CASHPAYMENT = (float)$receipt->amount;
        } else {
            $data->CASHPAYMENT = 0;
            $data->TPAYMENT_SUBFORM = array();

            $dataItem = new stdClass();
            $dataItem->PAYDATE = $receipt->chequeDate;
            $dataItem->QPRICE  = (float)$receipt->amount;
            $dataItem->CARDNUM = $receipt->chequeNumber;
            $dataItem->BANKCODE= $db->getBankObjectByName($receipt->bank)->bankCode;
            array_push($data->TPAYMENT_SUBFORM,$dataItem);

        }

        $db->displayObject($data);


        $dataResponse = $client->sendPostData("TINVOICES",json_encode($data));


        $erpDocumentCode = $dataResponse->IVNUM;

        if(strcmp($erpDocumentCode,'')!=0){
            $erpErrorStatus = 1;
            $erpErrorMessage = "OK";
        } else {
            $erpErrorStatus = -1;
            $erpErrorMessage = json_encode($dataResponse);
        }

        $documentStatus = new DocumentStatus(
            $id         = $receipt->receiptID,
            $table      = $db->getDocumentStatusTypeByTable("Receipts"),
            $status     = $erpErrorStatus,
            $reason     = $erpErrorMessage,
            $exportID   = 0,
            $exportCode = $erpDocumentCode
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
        $client->complete();

    }



}



?>
