<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Tender.php');
require_once('../../../backend/core/model/TenderItem.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/DocumentStatus.php');


function outboundTenders($db, $client)
{
    $tenders = $db->getDocumentForExports("Tenders", true, "AND tender_id > 0 LIMIT 1 ");

    foreach ($tenders as $tender){



        $data = new stdClass();
        $data->DETAILS      = $tender->tenderCode;
        $data->CUSTNAME     = $db->getCustomerObjectByID($tender->customerID)->customerCode;
        $data->PDATE        = $tender->tenderDate;
        $data->CPROFITEMS_SUBFORM   = array();

        foreach ($tender->tenderItems as $tenderLine) {

            $item = $db->getItemObjectByID($tenderLine->itemID);

            $tenderLine = outboundTendersAfterTenderItemLineBeforeTenderItemObjectCreation($item,$tenderLine);

            $dataItem = new stdClass();
            $dataItem->PARTNAME = $item->itemCode;
            $dataItem->TQUANT   = (float)$tenderLine->qty;
            $dataItem->PRICE    = (float)$tenderLine->unitPrice / (float)$item->subunits; //unitPrice / subunits
            array_push($data->CPROFITEMS_SUBFORM,$dataItem);
        }

        $data = outboundTendersAfterObjectCreationBeforeErpSend($data,$tender);

        $dataResponse = $client->sendPostData("CPROF",json_encode($data));


        $erpDocumentCode = $dataResponse->CPROFNUM;

        if(strcmp($erpDocumentCode,'')!=0){
            $erpErrorStatus = 1;
            $erpErrorMessage = "OK";
        } else {
            $erpErrorStatus = -1;
            $erpErrorMessage = json_encode($dataResponse);
        }

        $documentStatus = new DocumentStatus(
            $id         = $tender->tenderID,
            $table      = $db->getDocumentStatusTypeByTable("Tenders"),
            $status     = $erpErrorStatus,
            $reason     = $erpErrorMessage,
            $exportID   = 0,
            $exportCode = $erpDocumentCode
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
        $client->complete();
    }



}

function outboundTendersAfterObjectCreationBeforeErpSend($data,$tender){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'outboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

function outboundTendersAfterTenderItemLineBeforeTenderItemObjectCreation($item,$tenderLine){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'outboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $tenderLine;
}

?>
