<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('dbinfo.php');
require_once('importCustomers.php');
require_once('importSuppliers.php');
require_once('importItems.php');
require_once('importContractPrices.php');
require_once('importCategories_custom.php');
require_once('importDiscountGroups.php');
require_once('importInvoices.php');
require_once('importUOMS.php');



require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');
$myfile = fopen("PARSER_STATUS.txt", "w");
$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$dateFilter = date('Y-m-d', strtotime("-4 days"));


echo "Session ID: ".$client->getSessionID()."<br>";
echo "<br>--START-- <br>".date('d-m-Y H:i:s')."<br>";

echo "<br>IMPORT CUSTOMERS: <br>".date('d-m-Y H:i:s');
importCustomers($client,$dateFilter,$myfile);
fwrite($myfile, "\nIMPORT CUSTOMERS: ".date('d-m-Y H:i:s'));

echo "<br>IMPORT SUPPLIERS: <br>".date('d-m-Y H:i:s');
importSuppliers($client,$dateFilter);
fwrite($myfile, "\nIMPORT SUPPLIERS: ".date('d-m-Y H:i:s'));

echo "<br>IMPORT UOMS: <br>".date('d-m-Y H:i:s');
importUOMS($client,$today);
fwrite($myfile, "\nIMPORT UOMS: ".date('d-m-Y H:i:s'));

echo "<br>IMPORT ITEMS: <br>".date('d-m-Y H:i:s');
importItems($client,$dateFilter);
fwrite($myfile, "\nIMPORT ITEMS: ".date('d-m-Y H:i:s'));

// echo "<br>IMPORT CONTRACT PRICES: <br>".date('d-m-Y H:i:s');
// importContractPrices($client,$dateFilter);
// fwrite($myfile, "\nIMPORT CONTRACT PRICES: ".date('d-m-Y H:i:s'));

// echo "<br>IMPORT CATEGORY NAMES: <br>".date('d-m-Y H:i:s');
// importCategories_custom($client,$dateFilter);

echo "<br>IMPORT DISCOUNT GROUPS: <br>".date('d-m-Y H:i:s');
importDiscountGroups($client,$dateFilter);
fwrite($myfile, "\nIMPORT DISCOUNT GROUPS: ".date('d-m-Y H:i:s'));

// echo "<br>IMPORT INVOICES: <br>".date('d-m-Y H:i:s');
//importInvoices($client,$dateFilter);

echo "<br>--END-- <br>".date('d-m-Y H:i:s');
fclose($myfile);

?>