<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class Action_Initial_PrefsPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Action Initial Prefs');
            $this->SetMenuLabel('Action Initial Prefs');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Action_Initial_Prefs`');
            $this->dataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true),
                    new IntegerField('tender_group_id', true),
                    new IntegerField('tender_category_id', true),
                    new IntegerField('order_group_id', true),
                    new IntegerField('order_category_id', true),
                    new IntegerField('waybill_group_id', true),
                    new IntegerField('waybill_category_id', true),
                    new IntegerField('invoice_group_id', true),
                    new IntegerField('invoice_category_id', true),
                    new IntegerField('return_group_id', true),
                    new IntegerField('return_category_id', true),
                    new IntegerField('receipt_group_id', true),
                    new IntegerField('st_group_id', true),
                    new IntegerField('st_category_id', true),
                    new DateTimeField('timestamp', true)
                )
            );
            $this->dataset->AddLookupField('salesperson_id', '(SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons)', new IntegerField('salesperson_id'), new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', false, false, false, false, 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)_SalesPersonSearch'), 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)_SalesPersonSearch');
            $this->dataset->AddLookupField('tender_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'tender_group_id_CONCAT(group_code, \' - \',name)', 'tender_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'tender_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('tender_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'tender_category_id_CONCAT(category_code,\' - \',name)', 'tender_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'tender_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
            $this->dataset->AddLookupField('order_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'order_group_id_CONCAT(group_code, \' - \',name)', 'order_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'order_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('order_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'order_category_id_CONCAT(category_code,\' - \',name)', 'order_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'order_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
            $this->dataset->AddLookupField('waybill_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'waybill_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'waybill_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('waybill_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'waybill_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'waybill_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
            $this->dataset->AddLookupField('invoice_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'invoice_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'invoice_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('invoice_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'invoice_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'invoice_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
            $this->dataset->AddLookupField('return_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'return_group_id_CONCAT(group_code, \' - \',name)', 'return_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'return_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('return_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'return_category_id_CONCAT(category_code,\' - \',name)', 'return_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'return_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
            $this->dataset->AddLookupField('receipt_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'receipt_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'receipt_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('st_group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'st_group_id_CONCAT(group_code, \' - \',name)', 'st_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'st_group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('st_category_id', '(SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories)', new IntegerField('category_id'), new StringField('CONCAT(category_code,\' - \',name)', false, false, false, false, 'st_category_id_CONCAT(category_code,\' - \',name)', 'st_category_id_CONCAT(category_code,\' - \',name)_CategorySearch'), 'st_category_id_CONCAT(category_code,\' - \',name)_CategorySearch');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson'),
                new FilterColumn($this->dataset, 'tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group'),
                new FilterColumn($this->dataset, 'tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category'),
                new FilterColumn($this->dataset, 'order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group'),
                new FilterColumn($this->dataset, 'order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category'),
                new FilterColumn($this->dataset, 'waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group'),
                new FilterColumn($this->dataset, 'waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category'),
                new FilterColumn($this->dataset, 'invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group'),
                new FilterColumn($this->dataset, 'invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category'),
                new FilterColumn($this->dataset, 'return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group'),
                new FilterColumn($this->dataset, 'return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category'),
                new FilterColumn($this->dataset, 'receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group'),
                new FilterColumn($this->dataset, 'st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group'),
                new FilterColumn($this->dataset, 'st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category'),
                new FilterColumn($this->dataset, 'timestamp', 'timestamp', 'Timestamp')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['salesperson_id'])
                ->addColumn($columns['tender_group_id'])
                ->addColumn($columns['tender_category_id'])
                ->addColumn($columns['order_group_id'])
                ->addColumn($columns['order_category_id'])
                ->addColumn($columns['waybill_group_id'])
                ->addColumn($columns['waybill_category_id'])
                ->addColumn($columns['invoice_group_id'])
                ->addColumn($columns['invoice_category_id'])
                ->addColumn($columns['return_group_id'])
                ->addColumn($columns['return_category_id'])
                ->addColumn($columns['receipt_group_id'])
                ->addColumn($columns['st_group_id'])
                ->addColumn($columns['st_category_id']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('salesperson_id')
                ->setOptionsFor('tender_group_id')
                ->setOptionsFor('tender_category_id')
                ->setOptionsFor('order_group_id')
                ->setOptionsFor('order_category_id')
                ->setOptionsFor('waybill_group_id')
                ->setOptionsFor('waybill_category_id')
                ->setOptionsFor('invoice_group_id')
                ->setOptionsFor('invoice_category_id')
                ->setOptionsFor('return_group_id')
                ->setOptionsFor('return_category_id')
                ->setOptionsFor('receipt_group_id')
                ->setOptionsFor('st_group_id')
                ->setOptionsFor('st_category_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('salesperson_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_salesperson_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('salesperson_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_salesperson_id_search');
            
            $filterBuilder->addColumn(
                $columns['salesperson_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('tender_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_tender_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('tender_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_tender_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['tender_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('tender_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_tender_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('tender_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_tender_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['tender_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('order_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_order_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('order_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_order_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['order_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('order_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_order_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('order_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_order_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['order_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('waybill_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_waybill_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('waybill_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_waybill_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['waybill_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('waybill_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_waybill_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('waybill_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_waybill_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['waybill_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('invoice_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_invoice_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('invoice_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_invoice_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['invoice_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('invoice_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_invoice_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('invoice_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_invoice_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['invoice_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('return_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_return_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('return_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_return_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['return_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('return_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_return_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('return_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_return_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['return_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('receipt_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_receipt_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('receipt_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_receipt_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['receipt_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('st_group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_st_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('st_group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_st_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['st_group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('st_category_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_st_category_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('st_category_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Action_Initial_Prefs_st_category_id_search');
            
            $filterBuilder->addColumn(
                $columns['st_category_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for CONCAT(salesperson_code,' - ',first_name,' ',last_name) field
            //
            $column = new TextViewColumn('salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for CONCAT(salesperson_code,' - ',first_name,' ',last_name) field
            //
            $column = new TextViewColumn('salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for salesperson_id field
            //
            $editor = new DynamicCombobox('salesperson_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'SalesPersonSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true, true),
                    new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Salesperson', 'salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'edit_Action_Initial_Prefs_salesperson_id_search', $editor, $this->dataset, $lookupDataset, 'salesperson_id', 'CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tender_group_id field
            //
            $editor = new DynamicCombobox('tender_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Group', 'tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_tender_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for tender_category_id field
            //
            $editor = new DynamicCombobox('tender_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Category', 'tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_tender_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for order_group_id field
            //
            $editor = new DynamicCombobox('order_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Group', 'order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_order_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for order_category_id field
            //
            $editor = new DynamicCombobox('order_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Category', 'order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_order_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for waybill_group_id field
            //
            $editor = new DynamicCombobox('waybill_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Group', 'waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_waybill_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for waybill_category_id field
            //
            $editor = new DynamicCombobox('waybill_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Category', 'waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_waybill_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for invoice_group_id field
            //
            $editor = new DynamicCombobox('invoice_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Group', 'invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_invoice_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for invoice_category_id field
            //
            $editor = new DynamicCombobox('invoice_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Category', 'invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_invoice_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for return_group_id field
            //
            $editor = new DynamicCombobox('return_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Group', 'return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_return_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for return_category_id field
            //
            $editor = new DynamicCombobox('return_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Category', 'return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_return_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for receipt_group_id field
            //
            $editor = new DynamicCombobox('receipt_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Receipt Group', 'receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_receipt_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for st_group_id field
            //
            $editor = new DynamicCombobox('st_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Group', 'st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'edit_Action_Initial_Prefs_st_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for st_category_id field
            //
            $editor = new DynamicCombobox('st_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Category', 'st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'edit_Action_Initial_Prefs_st_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for tender_group_id field
            //
            $editor = new DynamicCombobox('tender_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Group', 'tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_tender_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for tender_category_id field
            //
            $editor = new DynamicCombobox('tender_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Category', 'tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_tender_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for order_group_id field
            //
            $editor = new DynamicCombobox('order_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Group', 'order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_order_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for order_category_id field
            //
            $editor = new DynamicCombobox('order_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Category', 'order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_order_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for waybill_group_id field
            //
            $editor = new DynamicCombobox('waybill_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Group', 'waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_waybill_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for waybill_category_id field
            //
            $editor = new DynamicCombobox('waybill_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Category', 'waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_waybill_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for invoice_group_id field
            //
            $editor = new DynamicCombobox('invoice_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Group', 'invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_invoice_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for invoice_category_id field
            //
            $editor = new DynamicCombobox('invoice_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Category', 'invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_invoice_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for return_group_id field
            //
            $editor = new DynamicCombobox('return_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Group', 'return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_return_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for return_category_id field
            //
            $editor = new DynamicCombobox('return_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Category', 'return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_return_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for receipt_group_id field
            //
            $editor = new DynamicCombobox('receipt_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Receipt Group', 'receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_receipt_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for st_group_id field
            //
            $editor = new DynamicCombobox('st_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Group', 'st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'multi_edit_Action_Initial_Prefs_st_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for st_category_id field
            //
            $editor = new DynamicCombobox('st_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Category', 'st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'multi_edit_Action_Initial_Prefs_st_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for salesperson_id field
            //
            $editor = new DynamicCombobox('salesperson_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'SalesPersonSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true, true),
                    new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Salesperson', 'salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'insert_Action_Initial_Prefs_salesperson_id_search', $editor, $this->dataset, $lookupDataset, 'salesperson_id', 'CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tender_group_id field
            //
            $editor = new DynamicCombobox('tender_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Group', 'tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_tender_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for tender_category_id field
            //
            $editor = new DynamicCombobox('tender_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Tender Category', 'tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_tender_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for order_group_id field
            //
            $editor = new DynamicCombobox('order_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Group', 'order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_order_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for order_category_id field
            //
            $editor = new DynamicCombobox('order_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Order Category', 'order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_order_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for waybill_group_id field
            //
            $editor = new DynamicCombobox('waybill_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Group', 'waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_waybill_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for waybill_category_id field
            //
            $editor = new DynamicCombobox('waybill_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Waybill Category', 'waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_waybill_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for invoice_group_id field
            //
            $editor = new DynamicCombobox('invoice_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Group', 'invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_invoice_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for invoice_category_id field
            //
            $editor = new DynamicCombobox('invoice_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Invoice Category', 'invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_invoice_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for return_group_id field
            //
            $editor = new DynamicCombobox('return_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Group', 'return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_return_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for return_category_id field
            //
            $editor = new DynamicCombobox('return_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Return Category', 'return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_return_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for receipt_group_id field
            //
            $editor = new DynamicCombobox('receipt_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Receipt Group', 'receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_receipt_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for st_group_id field
            //
            $editor = new DynamicCombobox('st_group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Group', 'st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'insert_Action_Initial_Prefs_st_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for st_category_id field
            //
            $editor = new DynamicCombobox('st_category_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('St Category', 'st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'insert_Action_Initial_Prefs_st_category_id_search', $editor, $this->dataset, $lookupDataset, 'category_id', 'CONCAT(category_code,\' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for CONCAT(salesperson_code,' - ',first_name,' ',last_name) field
            //
            $column = new TextViewColumn('salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for CONCAT(salesperson_code,' - ',first_name,' ',last_name) field
            //
            $column = new TextViewColumn('salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for CONCAT(salesperson_code,' - ',first_name,' ',last_name) field
            //
            $column = new TextViewColumn('salesperson_id', 'salesperson_id_CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'Salesperson', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('tender_group_id', 'tender_group_id_CONCAT(group_code, \' - \',name)', 'Tender Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('tender_category_id', 'tender_category_id_CONCAT(category_code,\' - \',name)', 'Tender Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('order_group_id', 'order_group_id_CONCAT(group_code, \' - \',name)', 'Order Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('order_category_id', 'order_category_id_CONCAT(category_code,\' - \',name)', 'Order Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('waybill_group_id', 'waybill_group_id_CONCAT(group_code, \' - \',name)', 'Waybill Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('waybill_category_id', 'waybill_category_id_CONCAT(category_code,\' - \',name)', 'Waybill Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('invoice_group_id', 'invoice_group_id_CONCAT(group_code, \' - \',name)', 'Invoice Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('invoice_category_id', 'invoice_category_id_CONCAT(category_code,\' - \',name)', 'Invoice Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('return_group_id', 'return_group_id_CONCAT(group_code, \' - \',name)', 'Return Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('return_category_id', 'return_category_id_CONCAT(category_code,\' - \',name)', 'Return Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('receipt_group_id', 'receipt_group_id_CONCAT(group_code, \' - \',name)', 'Receipt Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('st_group_id', 'st_group_id_CONCAT(group_code, \' - \',name)', 'St Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(category_code,' - ',name) field
            //
            $column = new TextViewColumn('st_category_id', 'st_category_id_CONCAT(category_code,\' - \',name)', 'St Category', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(false);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $selectQuery = 'SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'SalesPersonSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true, true),
                    new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_salesperson_id_search', 'salesperson_id', 'CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_tender_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_tender_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_order_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_order_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_waybill_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_waybill_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_invoice_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_invoice_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_return_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_return_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_receipt_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_st_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Action_Initial_Prefs_st_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'SalesPersonSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true, true),
                    new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_salesperson_id_search', 'salesperson_id', 'CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_tender_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_tender_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_order_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_order_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_waybill_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_waybill_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_invoice_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_invoice_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_return_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_return_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_receipt_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_st_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Action_Initial_Prefs_st_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT salesperson_id, CONCAT(salesperson_code,\' - \',first_name,\' \',last_name) FROM SalesPersons';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'SalesPersonSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('salesperson_id', true, true, true),
                    new StringField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_salesperson_id_search', 'salesperson_id', 'CONCAT(salesperson_code,\' - \',first_name,\' \',last_name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_tender_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_tender_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_order_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_order_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_waybill_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_waybill_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_invoice_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_invoice_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_return_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_return_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_receipt_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_st_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Action_Initial_Prefs_st_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_tender_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_tender_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_order_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_order_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_waybill_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_waybill_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_invoice_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_invoice_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_return_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_return_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_receipt_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_st_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT category_id, CONCAT(category_code,\' - \',name) FROM Categories';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'CategorySearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('category_id', true, true),
                    new StringField('CONCAT(category_code,\' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(category_code,\' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Action_Initial_Prefs_st_category_id_search', 'category_id', 'CONCAT(category_code,\' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new Action_Initial_PrefsPage("Action_Initial_Prefs", "Action_Initial_Prefs.php", GetCurrentUserPermissionsForPage("Action_Initial_Prefs"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("Action_Initial_Prefs"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
